/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.maven.plugin.csum;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.util.FileUtils;

public class ChecksumMojo
extends AbstractMojo {
    private String targetDirectory;
    private Digester md5Digester;
    private Digester sha1Digester;
    private Artifact artifact;
    private List<?> attachedArtifacts;

    public void execute() throws MojoExecutionException {
        File target;
        String sum;
        File file = this.artifact.getFile();
        try {
            sum = this.md5Digester.calc(file);
            target = new File(this.targetDirectory, file.getName() + ".md5");
            FileUtils.fileWrite((String)target.getAbsolutePath(), (String)sum);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error calculating digest. " + ex);
        }
        try {
            sum = this.sha1Digester.calc(file);
            target = new File(this.targetDirectory, file.getName() + ".sha1");
            FileUtils.fileWrite((String)target.getAbsolutePath(), (String)sum);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error calculating digest. " + ex);
        }
        Iterator<?> itr = this.attachedArtifacts.iterator();
        while (itr.hasNext()) {
            File target2;
            String sum2;
            file = ((Artifact)itr.next()).getFile();
            if (!this.performSum(file.getName())) continue;
            try {
                sum2 = this.md5Digester.calc(file);
                target2 = new File(this.targetDirectory, file.getName() + ".md5");
                FileUtils.fileWrite((String)target2.getAbsolutePath(), (String)sum2);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error calculating digest. " + ex);
            }
            try {
                sum2 = this.sha1Digester.calc(file);
                target2 = new File(this.targetDirectory, file.getName() + ".sha1");
                FileUtils.fileWrite((String)target2.getAbsolutePath(), (String)sum2);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error calculating digest. " + ex);
            }
        }
    }

    private boolean performSum(String file) {
        return file.endsWith("jar") || file.endsWith("exe") || file.endsWith("gz");
    }
}

