/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import org.apache.spark.unsafe.PlatformDependent;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class UnsafeMemoryAllocator
implements MemoryAllocator {
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        long address = PlatformDependent.UNSAFE.allocateMemory(size);
        return new MemoryBlock(null, address, size);
    }

    @Override
    public void free(MemoryBlock memory) {
        assert (memory.obj == null) : "baseObject not null; are you trying to use the off-heap allocator to free on-heap memory?";
        PlatformDependent.UNSAFE.freeMemory(memory.offset);
    }
}

