/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.spark-project.guava.primitives.Ints;

public class TransportConf {
    private final ConfigProvider conf;

    public TransportConf(ConfigProvider conf) {
        this.conf = conf;
    }

    public String ioMode() {
        return this.conf.get("spark.shuffle.io.mode", "NIO").toUpperCase();
    }

    public boolean preferDirectBufs() {
        return this.conf.getBoolean("spark.shuffle.io.preferDirectBufs", true);
    }

    public int connectionTimeoutMs() {
        long defaultNetworkTimeoutS = JavaUtils.timeStringAsSec(this.conf.get("spark.network.timeout", "120s"));
        long defaultTimeoutMs = JavaUtils.timeStringAsSec(this.conf.get("spark.shuffle.io.connectionTimeout", defaultNetworkTimeoutS + "s")) * 1000L;
        return (int)defaultTimeoutMs;
    }

    public int numConnectionsPerPeer() {
        return this.conf.getInt("spark.shuffle.io.numConnectionsPerPeer", 1);
    }

    public int backLog() {
        return this.conf.getInt("spark.shuffle.io.backLog", -1);
    }

    public int serverThreads() {
        return this.conf.getInt("spark.shuffle.io.serverThreads", 0);
    }

    public int clientThreads() {
        return this.conf.getInt("spark.shuffle.io.clientThreads", 0);
    }

    public int receiveBuf() {
        return this.conf.getInt("spark.shuffle.io.receiveBuffer", -1);
    }

    public int sendBuf() {
        return this.conf.getInt("spark.shuffle.io.sendBuffer", -1);
    }

    public int saslRTTimeoutMs() {
        return (int)JavaUtils.timeStringAsSec(this.conf.get("spark.shuffle.sasl.timeout", "30s")) * 1000;
    }

    public int maxIORetries() {
        return this.conf.getInt("spark.shuffle.io.maxRetries", 3);
    }

    public int ioRetryWaitTimeMs() {
        return (int)JavaUtils.timeStringAsSec(this.conf.get("spark.shuffle.io.retryWait", "5s")) * 1000;
    }

    public int memoryMapBytes() {
        return this.conf.getInt("spark.storage.memoryMapThreshold", 0x200000);
    }

    public boolean lazyFileDescriptor() {
        return this.conf.getBoolean("spark.shuffle.io.lazyFD", true);
    }

    public int portMaxRetries() {
        return this.conf.getInt("spark.port.maxRetries", 16);
    }

    public int maxSaslEncryptedBlockSize() {
        return Ints.checkedCast(JavaUtils.byteStringAsBytes(this.conf.get("spark.network.sasl.maxEncryptedBlockSize", "64k")));
    }

    public boolean saslServerAlwaysEncrypt() {
        return this.conf.getBoolean("spark.network.sasl.serverAlwaysEncrypt", false);
    }
}

