/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;

class SaslMessage
implements Encodable {
    private static final byte TAG_BYTE = -22;
    public final String appId;
    public final byte[] payload;

    public SaslMessage(String appId, byte[] payload) {
        this.appId = appId;
        this.payload = payload;
    }

    @Override
    public int encodedLength() {
        return 1 + Encoders.Strings.encodedLength(this.appId) + Encoders.ByteArrays.encodedLength(this.payload);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(-22);
        Encoders.Strings.encode(buf, this.appId);
        Encoders.ByteArrays.encode(buf, this.payload);
    }

    public static SaslMessage decode(ByteBuf buf) {
        if (buf.readByte() != -22) {
            throw new IllegalStateException("Expected SaslMessage, received something else (maybe your client does not have SASL enabled?)");
        }
        String appId = Encoders.Strings.decode(buf);
        byte[] payload = Encoders.ByteArrays.decode(buf);
        return new SaslMessage(appId, payload);
    }
}

