/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.spark-project.guava.base.Objects;

public final class RpcResponse
implements ResponseMessage {
    public final long requestId;
    public final byte[] response;

    public RpcResponse(long requestId, byte[] response) {
        this.requestId = requestId;
        this.response = response;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcResponse;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.ByteArrays.encodedLength(this.response);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.ByteArrays.encode(buf, this.response);
    }

    public static RpcResponse decode(ByteBuf buf) {
        long requestId = buf.readLong();
        byte[] response = Encoders.ByteArrays.decode(buf);
        return new RpcResponse(requestId, response);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestId, Arrays.hashCode(this.response));
    }

    public boolean equals(Object other) {
        if (other instanceof RpcResponse) {
            RpcResponse o = (RpcResponse)other;
            return this.requestId == o.requestId && Arrays.equals(this.response, o.response);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("requestId", this.requestId).add("response", this.response).toString();
    }
}

