/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.util.UUID;
import org.apache.qpid.amqp_1_0.codec.FixedSixteenWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDWriter
extends FixedSixteenWriter<UUID> {
    private static final byte FORMAT_CODE = -104;
    private static ValueWriter.Factory<UUID> FACTORY = new ValueWriter.Factory<UUID>(){

        @Override
        public ValueWriter<UUID> newInstance(ValueWriter.Registry registry) {
            return new UUIDWriter();
        }
    };

    @Override
    byte getFormatCode() {
        return -104;
    }

    @Override
    long convertValueToMSB(UUID value) {
        return value.getMostSignificantBits();
    }

    @Override
    long convertValueToLSB(UUID value) {
        return value.getLeastSignificantBits();
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(UUID.class, FACTORY);
    }
}

