/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.amqp_1_0.codec.SimpleVariableWidthWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringWriter
extends SimpleVariableWidthWriter<String> {
    private static final Charset ENCODING_CHARSET;
    private static final byte ONE_BYTE_CODE;
    private static final byte FOUR_BYTE_CODE;
    private final ValueCache<String, byte[]> _cachedEncodings = new ValueCache(10);
    private static ValueWriter.Factory<String> FACTORY;

    @Override
    protected byte getFourOctetEncodingCode() {
        return FOUR_BYTE_CODE;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return ONE_BYTE_CODE;
    }

    @Override
    protected byte[] getByteArray(String value) {
        boolean isFull = this._cachedEncodings.isFull();
        byte[] encoding = isFull ? (byte[])this._cachedEncodings.remove(value) : (byte[])this._cachedEncodings.get(value);
        if (encoding == null) {
            ByteBuffer buf = ENCODING_CHARSET.encode(value);
            if (buf.hasArray() && buf.arrayOffset() == 0 && buf.limit() == buf.capacity()) {
                encoding = buf.array();
            } else {
                byte[] bufArray = new byte[buf.limit() - buf.position()];
                buf.get(bufArray);
                encoding = bufArray;
            }
            this._cachedEncodings.put(value, encoding);
        } else if (isFull) {
            this._cachedEncodings.put(value, encoding);
        }
        return encoding;
    }

    @Override
    protected int getOffset() {
        return 0;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(String.class, FACTORY);
    }

    static {
        Charset defaultCharset = Charset.defaultCharset();
        if (defaultCharset.name().equals("UTF-16") || defaultCharset.name().equals("UTF-16BE")) {
            ENCODING_CHARSET = defaultCharset;
            ONE_BYTE_CODE = (byte)-94;
            FOUR_BYTE_CODE = (byte)-78;
        } else {
            ENCODING_CHARSET = Charset.forName("UTF-8");
            ONE_BYTE_CODE = (byte)-95;
            FOUR_BYTE_CODE = (byte)-79;
        }
        FACTORY = new ValueWriter.Factory<String>(){

            @Override
            public ValueWriter<String> newInstance(ValueWriter.Registry registry) {
                return new StringWriter();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int _cacheSize;

        public ValueCache(int cacheSize) {
            this._cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._cacheSize;
        }

        public boolean isFull() {
            return this.size() == this._cacheSize;
        }
    }
}

