/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import org.apache.qpid.amqp_1_0.codec.FixedEightWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleWriter
extends FixedEightWriter<Double> {
    private static final byte FORMAT_CODE = -126;
    private static ValueWriter.Factory<Double> FACTORY = new ValueWriter.Factory<Double>(){

        @Override
        public ValueWriter<Double> newInstance(ValueWriter.Registry registry) {
            return new DoubleWriter();
        }
    };

    @Override
    byte getFormatCode() {
        return -126;
    }

    @Override
    long convertValueToLong(Double value) {
        return Double.doubleToLongBits(value);
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Double.class, FACTORY);
    }
}

