/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineDelegationTokenSecretManagerService
extends AbstractService {
    private TimelineDelegationTokenSecretManager secretManager = null;
    private InetSocketAddress serviceAddr = null;

    public TimelineDelegationTokenSecretManagerService() {
        super(TimelineDelegationTokenSecretManagerService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long secretKeyInterval = conf.getLong("yarn.resourcemanager.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.resourcemanager.delegation.token.renew-interval", 86400000L);
        this.secretManager = new TimelineDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
        this.secretManager.startThreads();
        this.serviceAddr = TimelineUtils.getTimelineTokenServiceAddress((Configuration)this.getConfig());
        super.init(conf);
    }

    protected void serviceStop() throws Exception {
        this.secretManager.stopThreads();
        super.stop();
    }

    public Token<TimelineDelegationTokenIdentifier> createToken(UserGroupInformation ugi, String renewer) throws IOException {
        renewer = renewer == null ? ugi.getShortUserName() : renewer;
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        TimelineDelegationTokenIdentifier tokenIdentifier = new TimelineDelegationTokenIdentifier(owner, new Text(renewer), realUser);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.secretManager);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)this.serviceAddr);
        return token;
    }

    public long renewToken(Token<TimelineDelegationTokenIdentifier> token, String renewer) throws IOException {
        return this.secretManager.renewToken(token, renewer);
    }

    public void cancelToken(Token<TimelineDelegationTokenIdentifier> token, String canceler) throws IOException {
        this.secretManager.cancelToken(token, canceler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroupInformation verifyToken(Token<TimelineDelegationTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream dis = new DataInputStream(buf);
        TimelineDelegationTokenIdentifier id = new TimelineDelegationTokenIdentifier();
        try {
            id.readFields((DataInput)dis);
            this.secretManager.verifyToken((AbstractDelegationTokenIdentifier)id, token.getPassword());
        }
        finally {
            dis.close();
        }
        return id.getUser();
    }
}

