/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDelegationTokenResponse;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenOperation;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebApp;
import org.apache.hadoop.yarn.server.timeline.security.TimelineClientAuthenticationService;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineClientAuthenticationService
extends KerberosAuthenticationHandler {
    public static final String TYPE = "kerberos-dt";
    private static final Set<String> DELEGATION_TOKEN_OPS = new HashSet();
    private static final String OP_PARAM = "op";
    private static final String ENTER = System.getProperty("line.separator");
    private ObjectMapper mapper = new ObjectMapper();

    public TimelineClientAuthenticationService() {
        YarnJacksonJaxbJsonProvider.configObjectMapper((ObjectMapper)this.mapper);
    }

    public String getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        boolean requestContinues = true;
        String op = request.getParameter(OP_PARAM);
        op = op != null ? op.toUpperCase() : null;
        if (!DELEGATION_TOKEN_OPS.contains(op)) return requestContinues;
        if (request.getMethod().equals("OPTIONS")) return requestContinues;
        TimelineDelegationTokenOperation dtOp = TimelineDelegationTokenOperation.valueOf((String)op);
        if (dtOp.getHttpMethod().equals(request.getMethod())) {
            if (dtOp.requiresKerberosCredentials() && token == null) {
                response.sendError(401, MessageFormat.format("Operation [{0}] requires SPNEGO authentication established", dtOp));
                return false;
            }
            TimelineDelegationTokenSecretManagerService secretManager = AHSWebApp.getInstance().getTimelineDelegationTokenSecretManagerService();
            try {
                TimelineDelegationTokenResponse res = null;
                switch (1.$SwitchMap$org$apache$hadoop$yarn$security$client$TimelineDelegationTokenOperation[dtOp.ordinal()]) {
                    case 1: {
                        UserGroupInformation ownerUGI = UserGroupInformation.createRemoteUser((String)token.getUserName());
                        String renewerParam = request.getParameter("renewer");
                        if (renewerParam == null) {
                            renewerParam = token.getUserName();
                        }
                        Token dToken = secretManager.createToken(ownerUGI, renewerParam);
                        res = new TimelineDelegationTokenResponse();
                        res.setType("url");
                        res.setContent((Object)dToken.encodeToUrlString());
                        break;
                    }
                    case 2: 
                    case 3: {
                        String tokenParam = request.getParameter("token");
                        if (tokenParam == null) {
                            response.sendError(400, MessageFormat.format("Operation [{0}] requires the parameter [{1}]", dtOp, "token"));
                            return false;
                        }
                        if (dtOp == TimelineDelegationTokenOperation.CANCELDELEGATIONTOKEN) {
                            Token dt = new Token();
                            dt.decodeFromUrlString(tokenParam);
                            secretManager.cancelToken(dt, token.getUserName());
                            break;
                        }
                        Token dt = new Token();
                        dt.decodeFromUrlString(tokenParam);
                        long expirationTime = secretManager.renewToken(dt, token.getUserName());
                        res = new TimelineDelegationTokenResponse();
                        res.setType("expirationTime");
                        res.setContent((Object)expirationTime);
                    }
                }
                if (!requestContinues) return requestContinues;
                response.setStatus(200);
                if (res == null) return false;
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                this.mapper.writeValue((Writer)writer, res);
                ((Writer)writer).write(ENTER);
                ((Writer)writer).flush();
                return false;
            }
            catch (IOException e) {
                throw new AuthenticationException(e.toString(), (Throwable)e);
            }
        }
        response.sendError(400, MessageFormat.format("Wrong HTTP method [{0}] for operation [{1}], it should be [{2}]", request.getMethod(), dtOp, dtOp.getHttpMethod()));
        return false;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String delegationParam = request.getParameter("delegation");
        if (delegationParam != null) {
            Token dt = new Token();
            dt.decodeFromUrlString(delegationParam);
            TimelineDelegationTokenSecretManagerService secretManager = AHSWebApp.getInstance().getTimelineDelegationTokenSecretManagerService();
            UserGroupInformation ugi = secretManager.verifyToken(dt);
            String shortName = ugi.getShortUserName();
            token = new AuthenticationToken(shortName, ugi.getUserName(), this.getType());
            token.setExpires(0L);
        } else {
            token = super.authenticate(request, response);
        }
        return token;
    }

    static {
        DELEGATION_TOKEN_OPS.add(TimelineDelegationTokenOperation.GETDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(TimelineDelegationTokenOperation.RENEWDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(TimelineDelegationTokenOperation.CANCELDELEGATIONTOKEN.toString());
    }
}

