/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebApp;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationHistoryClientService
extends ApplicationHistoryStoreTestUtils {
    ApplicationHistoryServer historyServer = null;
    String expectedLogUrl = null;

    @Before
    public void setup() {
        this.historyServer = new ApplicationHistoryServer();
        YarnConfiguration config = new YarnConfiguration();
        this.expectedLogUrl = WebAppUtils.getHttpSchemePrefix((Configuration)config) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)config) + "/applicationhistory/logs/localhost:0/container_0_0001_01_000001/" + "container_0_0001_01_000001/test user";
        config.setClass("yarn.timeline-service.generic-application-history.store-class", MemoryApplicationHistoryStore.class, ApplicationHistoryStore.class);
        this.historyServer.init((Configuration)config);
        this.historyServer.start();
        this.store = ((ApplicationHistoryManagerImpl)this.historyServer.getApplicationHistory()).getHistoryStore();
    }

    @After
    public void tearDown() throws Exception {
        AHSWebApp.resetInstance();
        this.historyServer.stop();
    }

    @Test
    public void testApplicationReport() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
        GetApplicationReportResponse response = this.historyServer.getClientService().getClientHandler().getApplicationReport(request);
        ApplicationReport appReport = response.getApplicationReport();
        Assert.assertNotNull((Object)appReport);
        Assert.assertEquals((Object)"application_0_0001", (Object)appReport.getApplicationId().toString());
        Assert.assertEquals((Object)"test type", (Object)appReport.getApplicationType().toString());
        Assert.assertEquals((Object)"test queue", (Object)appReport.getQueue().toString());
    }

    @Test
    public void testApplications() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)2);
        this.writeApplicationStartData(appId1);
        this.writeApplicationFinishData(appId1);
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        GetApplicationsResponse response = this.historyServer.getClientService().getClientHandler().getApplications(request);
        List appReport = response.getApplicationList();
        Assert.assertNotNull((Object)appReport);
        Assert.assertEquals((Object)appId, (Object)((ApplicationReport)appReport.get(0)).getApplicationId());
        Assert.assertEquals((Object)appId1, (Object)((ApplicationReport)appReport.get(1)).getApplicationId());
    }

    @Test
    public void testApplicationAttemptReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        this.writeApplicationAttemptStartData(appAttemptId);
        this.writeApplicationAttemptFinishData(appAttemptId);
        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetApplicationAttemptReportResponse response = this.historyServer.getClientService().getClientHandler().getApplicationAttemptReport(request);
        ApplicationAttemptReport attemptReport = response.getApplicationAttemptReport();
        Assert.assertNotNull((Object)attemptReport);
        Assert.assertEquals((Object)"appattempt_0_0001_000001", (Object)attemptReport.getApplicationAttemptId().toString());
    }

    @Test
    public void testApplicationAttempts() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ApplicationAttemptId appAttemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        this.writeApplicationAttemptStartData(appAttemptId);
        this.writeApplicationAttemptFinishData(appAttemptId);
        this.writeApplicationAttemptStartData(appAttemptId1);
        this.writeApplicationAttemptFinishData(appAttemptId1);
        GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)appId);
        GetApplicationAttemptsResponse response = this.historyServer.getClientService().getClientHandler().getApplicationAttempts(request);
        List attemptReports = response.getApplicationAttemptList();
        Assert.assertNotNull((Object)attemptReports);
        Assert.assertEquals((Object)appAttemptId, (Object)((ApplicationAttemptReport)attemptReports.get(0)).getApplicationAttemptId());
        Assert.assertEquals((Object)appAttemptId1, (Object)((ApplicationAttemptReport)attemptReports.get(1)).getApplicationAttemptId());
    }

    @Test
    public void testContainerReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        this.writeContainerStartData(containerId);
        this.writeContainerFinishData(containerId);
        this.writeApplicationFinishData(appId);
        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
        GetContainerReportResponse response = this.historyServer.getClientService().getClientHandler().getContainerReport(request);
        ContainerReport container = response.getContainerReport();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerId, (Object)container.getContainerId());
        Assert.assertEquals((Object)this.expectedLogUrl, (Object)container.getLogUrl());
    }

    @Test
    public void testContainers() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        ContainerId containerId1 = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)2);
        this.writeContainerStartData(containerId);
        this.writeContainerFinishData(containerId);
        this.writeContainerStartData(containerId1);
        this.writeContainerFinishData(containerId1);
        this.writeApplicationFinishData(appId);
        GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetContainersResponse response = this.historyServer.getClientService().getClientHandler().getContainers(request);
        List containers = response.getContainerList();
        Assert.assertNotNull((Object)containers);
        Assert.assertEquals((Object)containerId, (Object)((ContainerReport)containers.get(1)).getContainerId());
        Assert.assertEquals((Object)containerId1, (Object)((ContainerReport)containers.get(0)).getContainerId());
    }
}

