/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.cli.ApplicationCLI;
import org.apache.hadoop.yarn.client.cli.NodeCLI;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestYarnCLI {
    private YarnClient client = (YarnClient)Mockito.mock(YarnClient.class);
    ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setup() {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysOutStream));
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = (PrintStream)Mockito.spy((Object)new PrintStream(this.sysErrStream));
        System.setOut(this.sysOut);
    }

    @Test
    public void testGetApplicationReport() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport newApplicationReport = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport);
        int result = cli.run(new String[]{"-status", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplicationReport(applicationId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Application Report : ");
        pw.println("\tApplication-Id : application_1234_0005");
        pw.println("\tApplication-Name : appname");
        pw.println("\tApplication-Type : YARN");
        pw.println("\tUser : user");
        pw.println("\tQueue : queue");
        pw.println("\tStart-Time : 0");
        pw.println("\tFinish-Time : 0");
        pw.println("\tProgress : 53.79%");
        pw.println("\tState : FINISHED");
        pw.println("\tFinal-State : SUCCEEDED");
        pw.println("\tTracking-URL : N/A");
        pw.println("\tRPC Port : 124");
        pw.println("\tAM Host : host");
        pw.println("\tDiagnostics : diagnostics");
        pw.close();
        String appReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
    }

    @Test
    public void testGetApplicationReportException() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenThrow(new Throwable[]{new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM.")});
        try {
            cli.run(new String[]{"-status", applicationId.toString()});
            junit.framework.Assert.fail();
        }
        catch (Exception ex) {
            junit.framework.Assert.assertTrue((boolean)(ex instanceof ApplicationNotFoundException));
            junit.framework.Assert.assertEquals((String)("Application with id '" + applicationId + "' doesn't exist in RM."), (String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplications() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport newApplicationReport = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.RUNNING, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        ArrayList<ApplicationReport> applicationReports = new ArrayList<ApplicationReport>();
        applicationReports.add(newApplicationReport);
        ApplicationId applicationId2 = ApplicationId.newInstance((long)1234L, (int)6);
        ApplicationReport newApplicationReport2 = ApplicationReport.newInstance((ApplicationId)applicationId2, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId2, (int)2), (String)"user2", (String)"queue2", (String)"appname2", (String)"host2", (int)125, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics2", (String)"url2", (long)2L, (long)2L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.63789f, (String)"NON-YARN", null);
        applicationReports.add(newApplicationReport2);
        ApplicationId applicationId3 = ApplicationId.newInstance((long)1234L, (int)7);
        ApplicationReport newApplicationReport3 = ApplicationReport.newInstance((ApplicationId)applicationId3, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId3, (int)3), (String)"user3", (String)"queue3", (String)"appname3", (String)"host3", (int)126, null, (YarnApplicationState)YarnApplicationState.RUNNING, (String)"diagnostics3", (String)"url3", (long)3L, (long)3L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.73789f, (String)"MAPREDUCE", null);
        applicationReports.add(newApplicationReport3);
        ApplicationId applicationId4 = ApplicationId.newInstance((long)1234L, (int)8);
        ApplicationReport newApplicationReport4 = ApplicationReport.newInstance((ApplicationId)applicationId4, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId4, (int)4), (String)"user4", (String)"queue4", (String)"appname4", (String)"host4", (int)127, null, (YarnApplicationState)YarnApplicationState.FAILED, (String)"diagnostics4", (String)"url4", (long)4L, (long)4L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.83789f, (String)"NON-MAPREDUCE", null);
        applicationReports.add(newApplicationReport4);
        ApplicationId applicationId5 = ApplicationId.newInstance((long)1234L, (int)9);
        ApplicationReport newApplicationReport5 = ApplicationReport.newInstance((ApplicationId)applicationId5, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId5, (int)5), (String)"user5", (String)"queue5", (String)"appname5", (String)"host5", (int)128, null, (YarnApplicationState)YarnApplicationState.ACCEPTED, (String)"diagnostics5", (String)"url5", (long)5L, (long)5L, (FinalApplicationStatus)FinalApplicationStatus.KILLED, null, (String)"N/A", (float)0.93789f, (String)"HIVE", null);
        applicationReports.add(newApplicationReport5);
        ApplicationId applicationId6 = ApplicationId.newInstance((long)1234L, (int)10);
        ApplicationReport newApplicationReport6 = ApplicationReport.newInstance((ApplicationId)applicationId6, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId6, (int)6), (String)"user6", (String)"queue6", (String)"appname6", (String)"host6", (int)129, null, (YarnApplicationState)YarnApplicationState.SUBMITTED, (String)"diagnostics6", (String)"url6", (long)6L, (long)6L, (FinalApplicationStatus)FinalApplicationStatus.KILLED, null, (String)"N/A", (float)0.99789f, (String)"PIG", null);
        applicationReports.add(newApplicationReport6);
        HashSet appType1 = new HashSet();
        EnumSet<YarnApplicationState> appState1 = EnumSet.noneOf(YarnApplicationState.class);
        appState1.add(YarnApplicationState.RUNNING);
        appState1.add(YarnApplicationState.ACCEPTED);
        appState1.add(YarnApplicationState.SUBMITTED);
        Mockito.when((Object)this.client.getApplications(appType1, appState1)).thenReturn((Object)this.getApplicationReports(applicationReports, appType1, appState1, false));
        int result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType1, appState1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType1 + " and states: " + appState1 + ")" + ":" + 4);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t           RUNNING\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0007\t            ");
        pw.print("appname3\t           MAPREDUCE\t     user3\t    ");
        pw.print("queue3\t           RUNNING\t         ");
        pw.print("SUCCEEDED\t         73.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0009\t            ");
        pw.print("appname5\t                HIVE\t     user5\t    ");
        pw.print("queue5\t          ACCEPTED\t            ");
        pw.print("KILLED\t         93.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0010\t            ");
        pw.print("appname6\t                 PIG\t     user6\t    ");
        pw.print("queue6\t         SUBMITTED\t            ");
        pw.print("KILLED\t         99.79%");
        pw.println("\t                                N/A");
        pw.close();
        String appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet<String> appType2 = new HashSet<String>();
        appType2.add("YARN");
        appType2.add("NON-YARN");
        EnumSet<YarnApplicationState> appState2 = EnumSet.noneOf(YarnApplicationState.class);
        appState2.add(YarnApplicationState.RUNNING);
        appState2.add(YarnApplicationState.ACCEPTED);
        appState2.add(YarnApplicationState.SUBMITTED);
        Mockito.when((Object)this.client.getApplications(appType2, appState2)).thenReturn((Object)this.getApplicationReports(applicationReports, appType2, appState2, false));
        result = cli.run(new String[]{"-list", "-appTypes", "YARN, ,,  NON-YARN", "   ,, ,,"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType2, appState2);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType2 + " and states: " + appState2 + ")" + ":" + 1);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t           RUNNING\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)2))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet appType3 = new HashSet();
        EnumSet<YarnApplicationState> appState3 = EnumSet.noneOf(YarnApplicationState.class);
        appState3.add(YarnApplicationState.FINISHED);
        appState3.add(YarnApplicationState.FAILED);
        Mockito.when((Object)this.client.getApplications(appType3, appState3)).thenReturn((Object)this.getApplicationReports(applicationReports, appType3, appState3, false));
        result = cli.run(new String[]{"-list", "--appStates", "FINISHED ,, , FAILED", ",,FINISHED"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType3, appState3);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType3 + " and states: " + appState3 + ")" + ":" + 2);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0008\t            ");
        pw.print("appname4\t       NON-MAPREDUCE\t     user4\t    ");
        pw.print("queue4\t            FAILED\t         ");
        pw.print("SUCCEEDED\t         83.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)3))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet<String> appType4 = new HashSet<String>();
        appType4.add("YARN");
        appType4.add("NON-YARN");
        EnumSet<YarnApplicationState> appState4 = EnumSet.noneOf(YarnApplicationState.class);
        appState4.add(YarnApplicationState.FINISHED);
        appState4.add(YarnApplicationState.FAILED);
        Mockito.when((Object)this.client.getApplications(appType4, appState4)).thenReturn((Object)this.getApplicationReports(applicationReports, appType4, appState4, false));
        result = cli.run(new String[]{"-list", "--appTypes", "YARN,NON-YARN", "--appStates", "FINISHED ,, , FAILED"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType2, appState2);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType4 + " and states: " + appState4 + ")" + ":" + 1);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)4))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        result = cli.run(new String[]{"-list", "--appStates", "FINISHED ,, , INVALID"});
        Assert.assertEquals((long)-1L, (long)result);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("The application state  INVALID is invalid.");
        pw.print("The valid application state can be one of the following: ");
        StringBuilder sb = new StringBuilder();
        sb.append("ALL,");
        for (YarnApplicationState state : YarnApplicationState.values()) {
            sb.append(state + ",");
        }
        String output = sb.toString();
        pw.println(output.substring(0, output.length() - 1));
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)4))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet appType5 = new HashSet();
        EnumSet<YarnApplicationState> appState5 = EnumSet.noneOf(YarnApplicationState.class);
        appState5.add(YarnApplicationState.FINISHED);
        Mockito.when((Object)this.client.getApplications(appType5, appState5)).thenReturn((Object)this.getApplicationReports(applicationReports, appType5, appState5, true));
        result = cli.run(new String[]{"-list", "--appStates", "FINISHED ,, , ALL"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType5, appState5);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType5 + " and states: " + appState5 + ")" + ":" + 6);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0005\t             ");
        pw.print("appname\t                YARN\t      user\t     ");
        pw.print("queue\t           RUNNING\t         ");
        pw.print("SUCCEEDED\t         53.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0007\t            ");
        pw.print("appname3\t           MAPREDUCE\t     user3\t    ");
        pw.print("queue3\t           RUNNING\t         ");
        pw.print("SUCCEEDED\t         73.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0008\t            ");
        pw.print("appname4\t       NON-MAPREDUCE\t     user4\t    ");
        pw.print("queue4\t            FAILED\t         ");
        pw.print("SUCCEEDED\t         83.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0009\t            ");
        pw.print("appname5\t                HIVE\t     user5\t    ");
        pw.print("queue5\t          ACCEPTED\t            ");
        pw.print("KILLED\t         93.79%");
        pw.println("\t                                N/A");
        pw.print("         application_1234_0010\t            ");
        pw.print("appname6\t                 PIG\t     user6\t    ");
        pw.print("queue6\t         SUBMITTED\t            ");
        pw.print("KILLED\t         99.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)5))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        HashSet<String> appType6 = new HashSet<String>();
        appType6.add("YARN");
        appType6.add("NON-YARN");
        EnumSet<YarnApplicationState> appState6 = EnumSet.noneOf(YarnApplicationState.class);
        appState6.add(YarnApplicationState.FINISHED);
        Mockito.when((Object)this.client.getApplications(appType6, appState6)).thenReturn((Object)this.getApplicationReports(applicationReports, appType6, appState6, false));
        result = cli.run(new String[]{"-list", "-appTypes", "YARN, ,,  NON-YARN", "--appStates", "finished"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getApplications(appType6, appState6);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total number of applications (application-types: " + appType6 + " and states: " + appState6 + ")" + ":" + 1);
        pw.print("                Application-Id\t    Application-Name");
        pw.print("\t    Application-Type");
        pw.print("\t      User\t     Queue\t             State\t       ");
        pw.print("Final-State\t       Progress");
        pw.println("\t                       Tracking-URL");
        pw.print("         application_1234_0006\t            ");
        pw.print("appname2\t            NON-YARN\t     user2\t    ");
        pw.print("queue2\t          FINISHED\t         ");
        pw.print("SUCCEEDED\t         63.79%");
        pw.println("\t                                N/A");
        pw.close();
        appsReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appsReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)6))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    private List<ApplicationReport> getApplicationReports(List<ApplicationReport> applicationReports, Set<String> appTypes, EnumSet<YarnApplicationState> appStates, boolean allStates) {
        ArrayList<ApplicationReport> appReports = new ArrayList<ApplicationReport>();
        if (allStates) {
            for (YarnApplicationState state : YarnApplicationState.values()) {
                appStates.add(state);
            }
        }
        for (ApplicationReport appReport : applicationReports) {
            if (appTypes != null && !appTypes.isEmpty() && !appTypes.contains(appReport.getApplicationType()) || appStates != null && !appStates.isEmpty() && !appStates.contains(appReport.getYarnApplicationState())) continue;
            appReports.add(appReport);
        }
        return appReports;
    }

    @Test(timeout=10000L)
    public void testAppsHelpCommand() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationCLI spyCli = (ApplicationCLI)Mockito.spy((Object)cli);
        int result = spyCli.run(new String[]{"-help"});
        junit.framework.Assert.assertTrue((result == 0 ? 1 : 0) != 0);
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
        junit.framework.Assert.assertEquals((String)this.createApplicationCLIHelpMessage(), (String)this.sysOutStream.toString());
        this.sysOutStream.reset();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        result = cli.run(new String[]{"-kill", applicationId.toString(), "args"});
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
        junit.framework.Assert.assertEquals((String)this.createApplicationCLIHelpMessage(), (String)this.sysOutStream.toString());
        this.sysOutStream.reset();
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        result = cli.run(new String[]{"-status", nodeId.toString(), "args"});
        ((ApplicationCLI)Mockito.verify((Object)spyCli)).printUsage((Options)Matchers.any(Options.class));
        junit.framework.Assert.assertEquals((String)this.createApplicationCLIHelpMessage(), (String)this.sysOutStream.toString());
    }

    @Test(timeout=5000L)
    public void testNodesHelpCommand() throws Exception {
        NodeCLI nodeCLI = new NodeCLI();
        nodeCLI.setClient(this.client);
        nodeCLI.setSysOutPrintStream(this.sysOut);
        nodeCLI.setSysErrPrintStream(this.sysErr);
        nodeCLI.run(new String[0]);
        junit.framework.Assert.assertEquals((String)this.createNodeCLIHelpMessage(), (String)this.sysOutStream.toString());
    }

    @Test
    public void testKillApplication() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport newApplicationReport2 = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport2);
        int result = cli.run(new String[]{"-kill", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).killApplication((ApplicationId)Matchers.any(ApplicationId.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Application " + applicationId + " has already finished ");
        ApplicationReport newApplicationReport = ApplicationReport.newInstance((ApplicationId)applicationId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.RUNNING, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null);
        Mockito.when((Object)this.client.getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)newApplicationReport);
        result = cli.run(new String[]{"-kill", applicationId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).killApplication((ApplicationId)Matchers.any(ApplicationId.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Killing application application_1234_0005");
        ((YarnClient)Mockito.doThrow((Throwable)new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM.")).when((Object)this.client)).getApplicationReport(applicationId);
        cli = this.createAndGetAppCLI();
        try {
            cli.run(new String[]{"-kill", applicationId.toString()});
            junit.framework.Assert.fail();
        }
        catch (Exception ex) {
            junit.framework.Assert.assertTrue((boolean)(ex instanceof ApplicationNotFoundException));
            junit.framework.Assert.assertEquals((String)("Application with id '" + applicationId + "' doesn't exist in RM."), (String)ex.getMessage());
        }
    }

    @Test
    public void testListClusterNodes() throws Exception {
        ArrayList nodeReports = new ArrayList();
        nodeReports.addAll(this.getNodeReports(1, NodeState.NEW));
        nodeReports.addAll(this.getNodeReports(2, NodeState.RUNNING));
        nodeReports.addAll(this.getNodeReports(1, NodeState.UNHEALTHY));
        nodeReports.addAll(this.getNodeReports(1, NodeState.DECOMMISSIONED));
        nodeReports.addAll(this.getNodeReports(1, NodeState.REBOOTED));
        nodeReports.addAll(this.getNodeReports(1, NodeState.LOST));
        NodeCLI cli = new NodeCLI();
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        HashSet<NodeState> nodeStates = new HashSet<NodeState>();
        nodeStates.add(NodeState.NEW);
        NodeState[] states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        int result = cli.run(new String[]{"-list", "--states", "NEW"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Total Nodes:1");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t            NEW\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        String nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.RUNNING);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "RUNNING"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:2");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host1:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)2))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        result = cli.run(new String[]{"-list"});
        Assert.assertEquals((long)0L, (long)result);
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)3))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.UNHEALTHY);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "UNHEALTHY"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:1");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t      UNHEALTHY\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)4))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.DECOMMISSIONED);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "DECOMMISSIONED"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:1");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t DECOMMISSIONED\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)5))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.REBOOTED);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "REBOOTED"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:1");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t       REBOOTED\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)6))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.LOST);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "LOST"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:1");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t           LOST\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)7))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        nodeStates.add(NodeState.NEW);
        nodeStates.add(NodeState.RUNNING);
        nodeStates.add(NodeState.LOST);
        nodeStates.add(NodeState.REBOOTED);
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--states", "NEW,RUNNING,LOST,REBOOTED"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:5");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t            NEW\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host1:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t       REBOOTED\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t           LOST\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)8))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        this.sysOutStream.reset();
        nodeStates.clear();
        for (NodeState s : NodeState.values()) {
            nodeStates.add(s);
        }
        states = nodeStates.toArray(new NodeState[0]);
        Mockito.when((Object)this.client.getNodeReports(states)).thenReturn((Object)this.getNodeReports(nodeReports, nodeStates));
        result = cli.run(new String[]{"-list", "--all"});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(states);
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        pw.println("Total Nodes:7");
        pw.print("         Node-Id\t     Node-State\tNode-Http-Address\t");
        pw.println("Number-of-Running-Containers");
        pw.print("         host0:0\t            NEW\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host1:0\t        RUNNING\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t      UNHEALTHY\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t DECOMMISSIONED\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t       REBOOTED\t       host1:8888\t");
        pw.println("                           0");
        pw.print("         host0:0\t           LOST\t       host1:8888\t");
        pw.println("                           0");
        pw.close();
        nodesReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)nodesReportStr, (String)this.sysOutStream.toString());
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)9))).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    private List<NodeReport> getNodeReports(List<NodeReport> nodeReports, Set<NodeState> nodeStates) {
        ArrayList<NodeReport> reports = new ArrayList<NodeReport>();
        for (NodeReport nodeReport : nodeReports) {
            if (!nodeStates.contains(nodeReport.getNodeState())) continue;
            reports.add(nodeReport);
        }
        return reports;
    }

    @Test
    public void testNodeStatus() throws Exception {
        NodeId nodeId = NodeId.newInstance((String)"host0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports(new NodeState[0])).thenReturn((Object)this.getNodeReports(3, NodeState.RUNNING));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(new NodeState[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Node Report : ");
        pw.println("\tNode-Id : host0:0");
        pw.println("\tRack : rack1");
        pw.println("\tNode-State : RUNNING");
        pw.println("\tNode-Http-Address : host1:8888");
        pw.println("\tLast-Health-Update : " + DateFormatUtils.format((Date)new Date(0L), (String)"E dd/MMM/yy hh:mm:ss:SSzz"));
        pw.println("\tHealth-Report : ");
        pw.println("\tContainers : 0");
        pw.println("\tMemory-Used : 0MB");
        pw.println("\tMemory-Capacity : 0MB");
        pw.println("\tCPU-Used : 0 vcores");
        pw.println("\tCPU-Capacity : 0 vcores");
        pw.close();
        String nodeStatusStr = baos.toString("UTF-8");
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println(nodeStatusStr);
    }

    @Test
    public void testAbsentNodeStatus() throws Exception {
        NodeId nodeId = NodeId.newInstance((String)"Absenthost0", (int)0);
        NodeCLI cli = new NodeCLI();
        Mockito.when((Object)this.client.getNodeReports(new NodeState[0])).thenReturn((Object)this.getNodeReports(0, NodeState.RUNNING));
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        cli.setSysErrPrintStream(this.sysErr);
        int result = cli.run(new String[]{"-status", nodeId.toString()});
        Assert.assertEquals((long)0L, (long)result);
        ((YarnClient)Mockito.verify((Object)this.client)).getNodeReports(new NodeState[0]);
        ((PrintStream)Mockito.verify((Object)this.sysOut, (VerificationMode)Mockito.times((int)1))).println((String)Matchers.isA(String.class));
        ((PrintStream)Mockito.verify((Object)this.sysOut)).println("Could not find the node report for node id : " + nodeId.toString());
    }

    @Test
    public void testAppCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new ApplicationCLI());
    }

    @Test
    public void testNodeCLIUsageInfo() throws Exception {
        this.verifyUsageInfo((YarnCLI)new NodeCLI());
    }

    @Test
    public void testMissingArguments() throws Exception {
        ApplicationCLI cli = this.createAndGetAppCLI();
        int result = cli.run(new String[]{"-status"});
        junit.framework.Assert.assertEquals((int)result, (int)-1);
        junit.framework.Assert.assertEquals((String)("Missing argument for options\n" + this.createApplicationCLIHelpMessage()), (String)this.sysOutStream.toString());
        this.sysOutStream.reset();
        NodeCLI nodeCLI = new NodeCLI();
        nodeCLI.setClient(this.client);
        nodeCLI.setSysOutPrintStream(this.sysOut);
        nodeCLI.setSysErrPrintStream(this.sysErr);
        result = nodeCLI.run(new String[]{"-status"});
        junit.framework.Assert.assertEquals((int)result, (int)-1);
        junit.framework.Assert.assertEquals((String)("Missing argument for options\n" + this.createNodeCLIHelpMessage()), (String)this.sysOutStream.toString());
    }

    private void verifyUsageInfo(YarnCLI cli) throws Exception {
        cli.setSysErrPrintStream(this.sysErr);
        cli.run(new String[0]);
        ((PrintStream)Mockito.verify((Object)this.sysErr)).println("Invalid Command Usage : ");
    }

    private List<NodeReport> getNodeReports(int noOfNodes, NodeState state) {
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>();
        for (int i = 0; i < noOfNodes; ++i) {
            NodeReport nodeReport = NodeReport.newInstance((NodeId)NodeId.newInstance((String)("host" + i), (int)0), (NodeState)state, (String)"host1:8888", (String)"rack1", (Resource)((Resource)Records.newRecord(Resource.class)), (Resource)((Resource)Records.newRecord(Resource.class)), (int)0, (String)"", (long)0L);
            nodeReports.add(nodeReport);
        }
        return nodeReports;
    }

    private ApplicationCLI createAndGetAppCLI() {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setClient(this.client);
        cli.setSysOutPrintStream(this.sysOut);
        return cli;
    }

    private String createApplicationCLIHelpMessage() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("usage: application");
        pw.println(" -appStates <States>        Works with -list to filter applications based");
        pw.println("                            on input comma-separated list of application");
        pw.println("                            states. The valid application state can be one");
        pw.println("                            of the following:");
        pw.println("                            ALL,NEW,NEW_SAVING,SUBMITTED,ACCEPTED,RUNNING,");
        pw.println("                            FINISHED,FAILED,KILLED");
        pw.println(" -appTypes <Types>          Works with -list to filter applications based");
        pw.println("                            on input comma-separated list of application");
        pw.println("                            types.");
        pw.println(" -help                      Displays help for all commands.");
        pw.println(" -kill <Application ID>     Kills the application.");
        pw.println(" -list                      List applications from the RM. Supports");
        pw.println("                            optional use of -appTypes to filter");
        pw.println("                            applications based on application type, and");
        pw.println("                            -appStates to filter applications based on");
        pw.println("                            application state");
        pw.println(" -status <Application ID>   Prints the status of the application.");
        pw.close();
        String appsHelpStr = baos.toString("UTF-8");
        return appsHelpStr;
    }

    private String createNodeCLIHelpMessage() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("usage: node");
        pw.println(" -all               Works with -list to list all nodes.");
        pw.println(" -list              List all running nodes. Supports optional use of");
        pw.println("                    -states to filter nodes based on node state, all -all");
        pw.println("                    to list all nodes.");
        pw.println(" -states <States>   Works with -list to filter nodes based on input");
        pw.println("                    comma-separated list of node states.");
        pw.println(" -status <NodeId>   Prints the status report of the node.");
        pw.close();
        String nodesHelpStr = baos.toString("UTF-8");
        return nodesHelpStr;
    }
}

