/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnClientImpl
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    protected ApplicationClientProtocol rmClient;
    protected InetSocketAddress rmAddress;
    protected long statePollIntervalMillis;
    private static final String ROOT = "root";

    public YarnClientImpl() {
        super(YarnClientImpl.class.getName());
    }

    private static InetSocketAddress getRmAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.rmAddress = YarnClientImpl.getRmAddress((Configuration)conf);
        this.statePollIntervalMillis = conf.getLong("yarn.client.app-submission.poll-interval", 1000L);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.rmClient = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.getConfig(), ApplicationClientProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        super.serviceStop();
    }

    private GetNewApplicationResponse getNewApplication() throws YarnException, IOException {
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        return this.rmClient.getNewApplication(request);
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        GetNewApplicationResponse newApp = this.getNewApplication();
        ApplicationId appId = newApp.getApplicationId();
        context.setApplicationId(appId);
        return new YarnClientApplication(newApp, context);
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        YarnApplicationState state;
        ApplicationId applicationId = appContext.getApplicationId();
        appContext.setApplicationId(applicationId);
        SubmitApplicationRequest request = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        this.rmClient.submitApplication(request);
        int pollCount = 0;
        while ((state = this.getApplicationReport(applicationId).getYarnApplicationState()).equals((Object)YarnApplicationState.NEW) || state.equals((Object)YarnApplicationState.NEW_SAVING)) {
            if (++pollCount % 10 == 0) {
                LOG.info((Object)("Application submission is not finished, submitted application " + applicationId + " is still in " + state));
            }
            try {
                Thread.sleep(this.statePollIntervalMillis);
            }
            catch (InterruptedException ie) {}
        }
        LOG.info((Object)("Submitted application " + applicationId + " to ResourceManager" + " at " + this.rmAddress));
        return applicationId;
    }

    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        LOG.info((Object)("Killing application " + applicationId));
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        this.rmClient.forceKillApplication(request);
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.rmClient.getApplicationReport(request);
        return response.getApplicationReport();
    }

    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        org.apache.hadoop.yarn.api.records.Token token = this.getApplicationReport(appId).getAMRMToken();
        Token amrmToken = null;
        if (token != null) {
            amrmToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, null);
        }
        return amrmToken;
    }

    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.getApplications(null, null);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        return this.getApplications(applicationTypes, null);
    }

    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.getApplications(null, applicationStates);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance(applicationTypes, applicationStates);
        GetApplicationsResponse response = this.rmClient.getApplications(request);
        return response.getApplicationList();
    }

    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        GetClusterMetricsRequest request = (GetClusterMetricsRequest)Records.newRecord(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.rmClient.getClusterMetrics(request);
        return response.getClusterMetrics();
    }

    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        EnumSet<NodeState> statesSet = states.length == 0 ? EnumSet.allOf(NodeState.class) : EnumSet.noneOf(NodeState.class);
        for (NodeState state : states) {
            statesSet.add(state);
        }
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(statesSet);
        GetClusterNodesResponse response = this.rmClient.getClusterNodes(request);
        return response.getNodeReports();
    }

    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        GetDelegationTokenRequest rmDTRequest = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.rmClient.getDelegationToken(rmDTRequest);
        return response.getRMDelegationToken();
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = (GetQueueInfoRequest)Records.newRecord(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    public QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        Records.newRecord(GetQueueInfoRequest.class);
        return this.rmClient.getQueueInfo(request).getQueueInfo();
    }

    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        GetQueueUserAclsInfoRequest request = (GetQueueUserAclsInfoRequest)Records.newRecord(GetQueueUserAclsInfoRequest.class);
        return this.rmClient.getQueueUserAcls(request).getUserAclsInfoList();
    }

    public List<QueueInfo> getAllQueues() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest("root", false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return queues;
    }

    public List<QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest("root", false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return queues;
    }

    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo parentQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return queues;
    }

    private void getChildQueues(QueueInfo parent, List<QueueInfo> queues, boolean recursive) {
        List childQueues = parent.getChildQueues();
        for (QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setRMClient(ApplicationClientProtocol rmClient) {
        this.rmClient = rmClient;
    }
}

