/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.jboss.netty.channel.DefaultFileRegion;

public class FadvisedFileRegion
extends DefaultFileRegion {
    private static final Log LOG = LogFactory.getLog(FadvisedFileRegion.class);
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedFileRegion(RandomAccessFile file, long position, long count, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier) throws IOException {
        super(file.getChannel(), position, count);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.manageOsCache && this.readaheadPool != null) {
            this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.getPosition() + position, (long)this.readaheadLength, this.getPosition() + this.getCount(), this.readaheadRequest);
        }
        return super.transferTo(target, position);
    }

    public void releaseExternalResources() {
        if (this.readaheadRequest != null) {
            this.readaheadRequest.cancel();
        }
        if (this.manageOsCache && this.getCount() > 0L) {
            try {
                NativeIO.POSIX.posixFadviseIfPossible((String)this.identifier, (FileDescriptor)this.fd, (long)this.getPosition(), (long)this.getCount(), (int)4);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Failed to manage OS cache for " + this.identifier), t);
            }
        }
        super.releaseExternalResources();
    }
}

