/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TestStagingCleanup;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestStagingCleanup
extends TestCase {
    private Configuration conf = new Configuration();
    private FileSystem fs;
    private String stagingJobDir = "tmpJobDir";
    private Path stagingJobPath = new Path(this.stagingJobDir);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testDeletionofStagingOnUnregistrationFailure() throws IOException {
        this.testDeletionofStagingOnUnregistrationFailure(2, false);
        this.testDeletionofStagingOnUnregistrationFailure(1, true);
    }

    private void testDeletionofStagingOnUnregistrationFailure(int maxAttempts, boolean shouldHaveDeleted) throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        TestMRApp appMaster = new TestMRApp(this, attemptId, null, JobStateInternal.RUNNING, maxAttempts);
        appMaster.crushUnregistration = true;
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        ((MRAppMaster.RunningAppContext)appMaster.getContext()).computeIsLastAMRetry();
        if (shouldHaveDeleted) {
            Assert.assertEquals((Object)new Boolean(true), (Object)appMaster.isLastAMRetry());
            ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
        } else {
            Assert.assertEquals((Object)new Boolean(false), (Object)appMaster.isLastAMRetry());
            ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).delete(this.stagingJobPath, true);
        }
    }

    @Test
    public void testDeletionofStaging() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        Assert.assertTrue((boolean)true);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc, JobStateInternal.RUNNING, 2);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((boolean)true, (boolean)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testNoDeletionofStagingOnReboot() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        Assert.assertTrue((boolean)true);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc, JobStateInternal.REBOOT, 2);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((boolean)false, (boolean)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.times((int)0))).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testDeletionofStagingOnReboot() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc, JobStateInternal.REBOOT, 1);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((boolean)true, (boolean)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testDeletionofStagingOnKill() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc, 4);
        appMaster.init(this.conf);
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.times((int)0))).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testDeletionofStagingOnKillLastTry() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc, 1);
        appMaster.init(this.conf);
        TestStagingCleanup.assertTrue((String)"appMaster.isLastAMRetry() is false", (boolean)appMaster.isLastAMRetry());
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        TestStagingCleanup.assertTrue((String)"MRAppMaster isn't stopped", (boolean)appMaster.isInState(Service.STATE.STOPPED));
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    private static RMHeartbeatHandler getStubbedHeartbeatHandler(AppContext appContext) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test(timeout=20000L)
    public void testStagingCleanupOrder() throws Exception {
        MRAppTestCleanup app = new MRAppTestCleanup(this, 1, 1, true, this.getClass().getName(), true);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        for (int waitTime = 20000; waitTime > 0 && app.numStops < 2; waitTime -= 100) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)1, (int)app.ContainerAllocatorStopped);
        Assert.assertEquals((int)2, (int)app.stagingDirCleanedup);
    }

    static /* synthetic */ FileSystem access$000(TestStagingCleanup x0) {
        return x0.fs;
    }

    static /* synthetic */ RMHeartbeatHandler access$100(AppContext x0) {
        return TestStagingCleanup.getStubbedHeartbeatHandler((AppContext)x0);
    }

    static /* synthetic */ Configuration access$200(TestStagingCleanup x0) {
        return x0.conf;
    }
}

