/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.NettyTransportCodec;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger((String)NettyServer.class.getName());
    private final Responder responder;
    private final Channel serverChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup("avro-netty-server");
    private final ChannelFactory channelFactory;
    private final CountDownLatch closed = new CountDownLatch(1);

    public NettyServer(Responder responder, InetSocketAddress addr) {
        this.responder = responder;
        this.channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap(this.channelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("frameDecoder", (ChannelHandler)new NettyTransportCodec.NettyFrameDecoder());
                p.addLast("frameEncoder", (ChannelHandler)new NettyTransportCodec.NettyFrameEncoder());
                p.addLast("handler", (ChannelHandler)new NettyServerAvroHandler());
                return p;
            }
        });
        this.serverChannel = bootstrap.bind((SocketAddress)addr);
        this.allChannels.add((Object)this.serverChannel);
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.closed.countDown();
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.serverChannel.getLocalAddress()).getPort();
    }

    @Override
    public void join() throws InterruptedException {
        this.closed.await();
    }

    class NettyServerAvroHandler
    extends SimpleChannelUpstreamHandler {
        private NettyTransceiver connectionMetadata = new NettyTransceiver();

        NettyServerAvroHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof ChannelStateEvent) {
                LOG.info(e.toString());
            }
            super.handleUpstream(ctx, e);
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NettyServer.this.allChannels.add((Object)e.getChannel());
            super.channelOpen(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            try {
                NettyTransportCodec.NettyDataPack dataPack = (NettyTransportCodec.NettyDataPack)e.getMessage();
                List<ByteBuffer> req = dataPack.getDatas();
                List<ByteBuffer> res = NettyServer.this.responder.respond(req, this.connectionMetadata);
                if (res != null) {
                    dataPack.setDatas(res);
                    e.getChannel().write((Object)dataPack);
                }
            }
            catch (IOException ex) {
                LOG.warn("unexpect error");
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            LOG.warn("Unexpected exception from downstream.", e.getCause());
            e.getChannel().close();
        }
    }
}

