package net.razorvine.pyro;

import java.io.Serializable;


/**
 * Minimalistic holders for Pyro config items.
 *
 * @author Irmen de Jong (irmen@razorvine.net)
 * @version 4.4
 */
public final class Config implements Serializable {
	private static final long serialVersionUID = 197645607890570066L;

	public static String MSG_TRACE_DIR = null;
	public static int NS_PORT = 9090;
	public static int NS_BCPORT = 9091;

	public final static int PROTOCOL_VERSION = 47;	// Pyro 4.26 
	public final static String PYROLITE_VERSION = "4.4";
	
	public enum SerializerType {
		pickle,
		serpent
	}

	public static boolean SERPENT_INDENT = false;
	public static boolean SERPENT_SET_LITERALS = false;     // set to true if talking to Python 3.2 or newer
	public static SerializerType SERIALIZER = SerializerType.serpent;
	public static boolean METADATA = true;		// get metadata from server?

	public static String DAEMON_NAME = "Pyro.Daemon";
}
