/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.dongliu.requests.AllTrustManager;
import net.dongliu.requests.CustomConnectionSocketFactory;
import net.dongliu.requests.CustomSSLConnectionSocketFactory;
import net.dongliu.requests.struct.Proxy;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;

public class Utils {
    static Registry<ConnectionSocketFactory> getConnectionSocketFactoryRegistry(Proxy proxy, boolean verify) {
        SSLContext sslContext;
        if (!verify) {
            try {
                sslContext = SSLContexts.custom().useTLS().build();
                sslContext.init(new KeyManager[0], new TrustManager[]{new AllTrustManager()}, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        } else {
            sslContext = SSLContexts.createSystemDefault();
        }
        CustomSSLConnectionSocketFactory sslsf = new CustomSSLConnectionSocketFactory(sslContext, proxy, verify);
        CustomConnectionSocketFactory psf = new CustomConnectionSocketFactory(proxy);
        return RegistryBuilder.create().register("http", (Object)psf).register("https", (Object)sslsf).build();
    }
}

