/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.dongliu.requests.ConnectionPool;
import net.dongliu.requests.Request;
import net.dongliu.requests.Response;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.Session;
import net.dongliu.requests.Utils;
import net.dongliu.requests.exception.RuntimeIOException;
import net.dongliu.requests.struct.Cookie;
import net.dongliu.requests.struct.Cookies;
import net.dongliu.requests.struct.Header;
import net.dongliu.requests.struct.Headers;
import net.dongliu.requests.struct.MultiPart;
import net.dongliu.requests.struct.Parameter;
import net.dongliu.requests.struct.Parameters;
import net.dongliu.requests.struct.Proxy;
import org.apache.commons.io.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;

class RequestExecutor<T> {
    private final Request request;
    private final ResponseProcessor<T> processor;
    private final Session session;
    private final ConnectionPool connectionPool;

    RequestExecutor(Request request, ResponseProcessor<T> processor, Session session, ConnectionPool connectionPool) {
        this.request = request;
        this.processor = processor;
        this.session = session;
        this.connectionPool = connectionPool;
    }

    /*
     * Exception decompiling
     */
    Response<T> execute() throws RuntimeIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient buildHttpClient(CredentialsProvider provider, HttpClientContext context) {
        HttpClientBuilder clientBuilder = HttpClients.custom().setUserAgent(this.request.getUserAgent());
        if (this.connectionPool != null) {
            clientBuilder.setConnectionManager(this.connectionPool.wrappedConnectionManager());
        } else {
            Registry<ConnectionSocketFactory> reg = Utils.getConnectionSocketFactoryRegistry(this.request.getProxy(), this.request.isVerify());
            BasicHttpClientConnectionManager manager = new BasicHttpClientConnectionManager(reg);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)manager);
        }
        if (this.request.getAuthInfo() != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.request.getAuthInfo().getUserName(), this.request.getAuthInfo().getPassword());
            provider.setCredentials(new AuthScope(this.request.getUrl().getHost(), this.request.getUrl().getPort()), (Credentials)credentials);
        }
        clientBuilder.setDefaultCredentialsProvider(provider);
        if (!this.request.isGzip()) {
            clientBuilder.disableContentCompression();
        }
        if (!this.request.isAllowRedirects()) {
            clientBuilder.disableRedirectHandling();
        }
        return clientBuilder.build();
    }

    private HttpRequestBase buildRequest(CredentialsProvider provider, HttpClientContext context) {
        Proxy proxy;
        HttpGet httpRequest;
        URI uri = this.buildFullUrl(this.request.getUrl(), this.request.getParameters());
        switch (this.request.getMethod()) {
            case POST: {
                httpRequest = this.buildHttpPost(uri, this.request);
                break;
            }
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(uri);
                break;
            }
            case PUT: {
                httpRequest = this.buildHttpPut(uri, this.request);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions(uri);
                break;
            }
            case TRACE: {
                httpRequest = new HttpTrace(uri);
                break;
            }
            case PATCH: {
                httpRequest = this.buildHttpPatch(uri, this.request);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported method:" + (Object)((Object)this.request.getMethod()));
            }
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(this.request.getConnectTimeout()).setSocketTimeout(this.request.getSocketTimeout()).setConnectionRequestTimeout(this.request.getConnectTimeout()).setCookieSpec("compatibility");
        Proxy proxy2 = proxy = this.connectionPool == null ? this.request.getProxy() : this.connectionPool.getProxy();
        if (proxy != null && (proxy.getScheme() == Proxy.Scheme.http || proxy.getScheme() == Proxy.Scheme.https)) {
            if (proxy.getAuthInfo() != null) {
                provider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword()));
            }
            HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getScheme().name());
            configBuilder.setProxy(httpHost);
        }
        httpRequest.setConfig(configBuilder.build());
        CookieStore cookieStore = context.getCookieStore();
        if (this.request.getCookies() != null) {
            for (Cookie cookie : this.request.getCookies()) {
                BasicClientCookie clientCookie = new BasicClientCookie((String)cookie.getName(), (String)cookie.getValue());
                clientCookie.setDomain(this.request.getUrl().getHost());
                clientCookie.setPath("/");
                cookieStore.addCookie((org.apache.http.cookie.Cookie)clientCookie);
            }
        }
        if (this.request.getHeaders() != null) {
            for (Header header : this.request.getHeaders()) {
                httpRequest.setHeader((String)header.getName(), (String)header.getValue());
            }
        }
        return httpRequest;
    }

    private HttpRequestBase buildHttpPut(URI uri, Request request) {
        this.checkHttpBody(request);
        HttpPut httpPut = new HttpPut(uri);
        if (request.getBody() != null) {
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
        } else if (request.getIn() != null) {
            httpPut.setEntity((HttpEntity)new InputStreamEntity(request.getIn()));
        } else if (request.getParamBody() != null) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(request.getParamBody().size());
            for (Parameter param : request.getParamBody()) {
                paramList.add(new BasicNameValuePair((String)param.getName(), (String)param.getValue()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, Charsets.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return httpPut;
    }

    private HttpPost buildHttpPost(URI uri, Request request) {
        this.checkHttpBody(request);
        HttpPost httpPost = new HttpPost(uri);
        if (request.getMultiParts() != null) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            for (Parameter parameter : request.getParamBody()) {
                entityBuilder.addTextBody((String)parameter.getName(), (String)parameter.getValue());
            }
            for (MultiPart f : request.getMultiParts()) {
                entityBuilder.addBinaryBody(f.getName(), f.getFile(), ContentType.create((String)f.getMime()), f.getFileName());
            }
            httpPost.setEntity(entityBuilder.build());
        } else if (request.getBody() != null) {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
        } else if (request.getIn() != null) {
            httpPost.setEntity((HttpEntity)new InputStreamEntity(request.getIn()));
        } else if (request.getParamBody() != null) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(request.getParamBody().size());
            for (Parameter param : request.getParamBody()) {
                paramList.add(new BasicNameValuePair((String)param.getName(), (String)param.getValue()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, Charsets.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return httpPost;
    }

    private HttpRequestBase buildHttpPatch(URI uri, Request request) {
        this.checkHttpBody(request);
        HttpPatch httpPatch = new HttpPatch(uri);
        if (request.getBody() != null) {
            httpPatch.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
        } else if (request.getIn() != null) {
            httpPatch.setEntity((HttpEntity)new InputStreamEntity(request.getIn()));
        } else if (request.getParamBody() != null) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(request.getParamBody().size());
            for (Parameter param : request.getParamBody()) {
                paramList.add(new BasicNameValuePair((String)param.getName(), (String)param.getValue()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, Charsets.UTF_8);
            httpPatch.setEntity((HttpEntity)entity);
        }
        return httpPatch;
    }

    private void checkHttpBody(Request request) {
        int bodyCount = 0;
        if (request.getBody() != null) {
            ++bodyCount;
        }
        if (request.getIn() != null) {
            ++bodyCount;
        }
        if (request.getParamBody() != null) {
            ++bodyCount;
        }
        if (request.getMultiParts() != null) {
            ++bodyCount;
        }
        if (bodyCount > 1) {
            throw new RuntimeException("More than one http request body have been set");
        }
    }

    private URI buildFullUrl(URI url, Parameters parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return url;
            }
            URIBuilder urlBuilder = new URIBuilder(url);
            for (Parameter param : parameters) {
                urlBuilder.addParameter((String)param.getName(), (String)param.getValue());
            }
            return urlBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Response<T> wrapResponse(CloseableHttpResponse httpResponse, HttpClientContext context) throws IOException {
        Response<T> response = new Response<T>();
        response.setRequest(this.request);
        response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        org.apache.http.Header[] respHeaders = httpResponse.getAllHeaders();
        Headers headers = new Headers();
        for (org.apache.http.Header header : respHeaders) {
            headers.add(new Header(header.getName(), header.getValue()));
        }
        response.setHeaders(headers);
        Cookies cookies = new Cookies();
        for (org.apache.http.cookie.Cookie c : context.getCookieStore().getCookies()) {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            cookie.setPath(c.getPath());
            cookie.setDomain(c.getDomain());
            cookie.setPath(c.getPath());
            cookie.setExpiry(c.getExpiryDate());
            cookies.add(cookie);
        }
        response.setCookies(cookies);
        response.setHistory(context.getRedirectLocations());
        HttpEntity entity = httpResponse.getEntity();
        T result = this.processor.convert(response.getStatusCode(), headers, entity);
        response.setBody(result);
        return response;
    }
}

