/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.dongliu.requests.ConnectionPool;
import net.dongliu.requests.FileResponseProcessor;
import net.dongliu.requests.Request;
import net.dongliu.requests.RequestExecutor;
import net.dongliu.requests.Response;
import net.dongliu.requests.ResponseHandler;
import net.dongliu.requests.ResponseHandlerAdapter;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.Session;
import net.dongliu.requests.StringResponseProcessor;
import net.dongliu.requests.exception.InvalidUrlException;
import net.dongliu.requests.exception.RuntimeIOException;
import net.dongliu.requests.struct.AuthInfo;
import net.dongliu.requests.struct.Cookie;
import net.dongliu.requests.struct.Cookies;
import net.dongliu.requests.struct.Header;
import net.dongliu.requests.struct.Headers;
import net.dongliu.requests.struct.Method;
import net.dongliu.requests.struct.MultiPart;
import net.dongliu.requests.struct.Parameter;
import net.dongliu.requests.struct.Parameters;
import net.dongliu.requests.struct.Proxy;

public class RequestBuilder {
    private Method method;
    private URI url;
    private Parameters parameters;
    private String userAgent = "Requests/1.6.5, Java";
    private Headers headers;
    private Cookies cookies;
    private byte[] body;
    private Parameters paramBody;
    private List<MultiPart> multiParts;
    private InputStream in;
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean gzip = true;
    private boolean verify = true;
    private boolean allowRedirects = true;
    private AuthInfo authInfo;
    private String[] cert;
    private Proxy proxy;
    private Session session;
    private ConnectionPool connectionPool;

    RequestBuilder() {
    }

    <T> Response<T> client(ResponseProcessor<T> processor) throws RuntimeIOException {
        return new RequestExecutor<T>(this.build(), processor, this.session, this.connectionPool).execute();
    }

    public <T> Response<T> handler(ResponseHandler<T> handler) throws RuntimeIOException {
        return this.client(new ResponseHandlerAdapter<T>(handler));
    }

    public Response<String> text() throws RuntimeIOException {
        return this.client(ResponseProcessor.string);
    }

    public Response<String> text(Charset charset) throws RuntimeIOException {
        return this.client(new StringResponseProcessor(charset));
    }

    public Response<String> text(String charset) throws RuntimeIOException {
        return this.text(Charset.forName(charset));
    }

    public Response<byte[]> bytes() throws RuntimeIOException {
        return this.client(ResponseProcessor.bytes);
    }

    public Response<File> file(File file) throws RuntimeIOException {
        return this.client(new FileResponseProcessor(file));
    }

    public Response<File> file(String filePath) throws RuntimeIOException {
        return this.client(new FileResponseProcessor(filePath));
    }

    RequestBuilder url(String url) throws InvalidUrlException {
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw InvalidUrlException.of(e);
        }
        return this;
    }

    Request build() {
        return new Request(this.method, this.url, this.parameters, this.userAgent, this.headers, this.in, this.multiParts, this.body, this.paramBody, this.authInfo, this.gzip, this.verify, this.cookies, this.allowRedirects, this.connectTimeout, this.socketTimeout, this.proxy);
    }

    public RequestBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public RequestBuilder params(Map<String, ?> params) {
        this.ensureParameters();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            this.parameters.add(new Parameter(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public RequestBuilder params(Parameter ... params) {
        this.ensureParameters();
        for (Parameter param : params) {
            this.parameters.add(new Parameter((String)param.getName(), param.getValue()));
        }
        return this;
    }

    public RequestBuilder param(String key, Object value) {
        this.ensureParameters();
        this.parameters.add(new Parameter(key, value));
        return this;
    }

    private void ensureParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
    }

    public RequestBuilder data(Map<String, ?> data) {
        this.ensureParamBody();
        for (Map.Entry<String, ?> e : data.entrySet()) {
            this.paramBody.add(new Parameter(e.getKey(), e.getValue()));
        }
        return this;
    }

    public RequestBuilder data(Parameter ... params) {
        this.ensureParamBody();
        for (Parameter param : params) {
            this.paramBody.add(param);
        }
        return this;
    }

    public RequestBuilder data(String key, Object value) {
        this.ensureParamBody();
        this.paramBody.add(new Parameter(key, value));
        return this;
    }

    private void ensureParamBody() {
        if (this.paramBody == null) {
            this.paramBody = new Parameters();
        }
    }

    public RequestBuilder data(byte[] data) {
        this.body = data;
        return this;
    }

    public RequestBuilder data(InputStream in) {
        this.in = in;
        return this;
    }

    public RequestBuilder data(String body, Charset charset) {
        return this.data(body.getBytes(charset));
    }

    RequestBuilder method(Method method) {
        this.method = method;
        return this;
    }

    public RequestBuilder headers(Map<String, ?> params) {
        this.ensureHeaders();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            this.headers.add(new Header(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public RequestBuilder headers(Header ... headers) {
        this.ensureHeaders();
        for (Header header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public RequestBuilder header(String key, Object value) {
        this.ensureHeaders();
        this.headers.add(new Header(key, value));
        return this;
    }

    private void ensureHeaders() {
        if (this.headers == null) {
            this.headers = new Headers();
        }
    }

    public RequestBuilder timeout(int timeout) {
        this.socketTimeout = this.connectTimeout = timeout;
        return this;
    }

    public RequestBuilder timeout(int connectTimeout, int socketTimeout) {
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        return this;
    }

    public RequestBuilder proxy(Proxy proxy) throws InvalidUrlException {
        this.proxy = proxy;
        return this;
    }

    public RequestBuilder gzip(boolean gzip) {
        this.gzip = gzip;
        return this;
    }

    public RequestBuilder verify(boolean verify) {
        this.verify = verify;
        return this;
    }

    public RequestBuilder auth(String userName, String password) {
        this.authInfo = new AuthInfo(userName, password);
        return this;
    }

    public RequestBuilder cookies(Map<String, String> cookies) {
        this.ensureCookies();
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.cookies.add(new Cookie(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public RequestBuilder cookies(Cookie ... cookies) {
        this.ensureCookies();
        for (Cookie cookie : cookies) {
            this.cookies.add(cookie);
        }
        return this;
    }

    public RequestBuilder cookie(String name, String value) {
        this.ensureCookies();
        this.cookies.add(new Cookie(name, value));
        return this;
    }

    private void ensureCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
    }

    public RequestBuilder allowRedirects(boolean allowRedirects) {
        this.allowRedirects = allowRedirects;
        return this;
    }

    public RequestBuilder cert(String ... cert) {
        throw new UnsupportedOperationException();
    }

    public RequestBuilder multiPart(List<MultiPart> files) {
        this.ensureMultiPart();
        this.multiParts.addAll(files);
        return this;
    }

    public RequestBuilder multiPart(MultiPart ... files) {
        this.ensureMultiPart();
        Collections.addAll(this.multiParts, files);
        return this;
    }

    public RequestBuilder multiPart(MultiPart file) {
        this.ensureMultiPart();
        this.multiParts.add(file);
        return this;
    }

    public RequestBuilder multiPart(String name, String filePath) {
        this.ensureMultiPart();
        this.multiParts.add(new MultiPart(name, filePath));
        return this;
    }

    private void ensureMultiPart() {
        if (this.multiParts == null) {
            this.multiParts = new ArrayList<MultiPart>();
        }
    }

    RequestBuilder session(Session session) {
        this.session = session;
        return this;
    }

    public RequestBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }
}

