/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SerializedConfigValue
extends AbstractConfigValue
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ConfigValue value;
    private boolean wasConfig;

    public SerializedConfigValue() {
        super(null);
    }

    SerializedConfigValue(ConfigValue configValue) {
        this();
        this.value = configValue;
        this.wasConfig = false;
    }

    SerializedConfigValue(Config config) {
        this(config.root());
        this.wasConfig = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.wasConfig) {
            return ((ConfigObject)this.value).toConfig();
        }
        return this.value;
    }

    private static void writeOriginField(DataOutput dataOutput, SerializedField serializedField, Object object) throws IOException {
        switch (serializedField) {
            case ORIGIN_DESCRIPTION: {
                dataOutput.writeUTF((String)object);
                break;
            }
            case ORIGIN_LINE_NUMBER: {
                dataOutput.writeInt((Integer)object);
                break;
            }
            case ORIGIN_END_LINE_NUMBER: {
                dataOutput.writeInt((Integer)object);
                break;
            }
            case ORIGIN_TYPE: {
                dataOutput.writeByte((Integer)object);
                break;
            }
            case ORIGIN_URL: {
                dataOutput.writeUTF((String)object);
                break;
            }
            case ORIGIN_COMMENTS: {
                List list = (List)object;
                int n = list.size();
                dataOutput.writeInt(n);
                for (String string : list) {
                    dataOutput.writeUTF(string);
                }
                break;
            }
            case ORIGIN_NULL_URL: 
            case ORIGIN_NULL_COMMENTS: {
                break;
            }
            default: {
                throw new IOException("Unhandled field from origin: " + (Object)((Object)serializedField));
            }
        }
    }

    static void writeOrigin(DataOutput dataOutput, SimpleConfigOrigin simpleConfigOrigin, SimpleConfigOrigin simpleConfigOrigin2) throws IOException {
        Map<SerializedField, Object> map = simpleConfigOrigin.toFieldsDelta(simpleConfigOrigin2);
        for (Map.Entry<SerializedField, Object> entry : map.entrySet()) {
            FieldOut fieldOut = new FieldOut(entry.getKey());
            Object object = entry.getValue();
            SerializedConfigValue.writeOriginField(fieldOut.data, fieldOut.code, object);
            SerializedConfigValue.writeField(dataOutput, fieldOut);
        }
        SerializedConfigValue.writeEndMarker(dataOutput);
    }

    static SimpleConfigOrigin readOrigin(DataInput dataInput, SimpleConfigOrigin simpleConfigOrigin) throws IOException {
        EnumMap<SerializedField, Object> enumMap = new EnumMap<SerializedField, Object>(SerializedField.class);
        while (true) {
            ArrayList<String> arrayList = null;
            SerializedField serializedField = SerializedConfigValue.readCode(dataInput);
            switch (serializedField) {
                case END_MARKER: {
                    return SimpleConfigOrigin.fromBase(simpleConfigOrigin, enumMap);
                }
                case ORIGIN_DESCRIPTION: {
                    dataInput.readInt();
                    arrayList = dataInput.readUTF();
                    break;
                }
                case ORIGIN_LINE_NUMBER: {
                    dataInput.readInt();
                    arrayList = dataInput.readInt();
                    break;
                }
                case ORIGIN_END_LINE_NUMBER: {
                    dataInput.readInt();
                    arrayList = dataInput.readInt();
                    break;
                }
                case ORIGIN_TYPE: {
                    dataInput.readInt();
                    arrayList = dataInput.readUnsignedByte();
                    break;
                }
                case ORIGIN_URL: {
                    dataInput.readInt();
                    arrayList = dataInput.readUTF();
                    break;
                }
                case ORIGIN_COMMENTS: {
                    dataInput.readInt();
                    int n = dataInput.readInt();
                    ArrayList<String> arrayList2 = new ArrayList<String>(n);
                    for (int i = 0; i < n; ++i) {
                        arrayList2.add(dataInput.readUTF());
                    }
                    arrayList = arrayList2;
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_COMMENTS: {
                    dataInput.readInt();
                    arrayList = "";
                    break;
                }
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new IOException("Not expecting this field here: " + (Object)((Object)serializedField));
                }
                case UNKNOWN: {
                    SerializedConfigValue.skipField(dataInput);
                }
            }
            if (arrayList == null) continue;
            enumMap.put(serializedField, (Object)arrayList);
        }
    }

    private static void writeValueData(DataOutput dataOutput, ConfigValue configValue) throws IOException {
        SerializedValueType serializedValueType = SerializedValueType.forValue(configValue);
        dataOutput.writeByte(serializedValueType.ordinal());
        switch (serializedValueType) {
            case BOOLEAN: {
                dataOutput.writeBoolean(((ConfigBoolean)configValue).unwrapped());
                break;
            }
            case NULL: {
                break;
            }
            case INT: {
                dataOutput.writeInt(((ConfigInt)configValue).unwrapped());
                dataOutput.writeUTF(((ConfigNumber)configValue).transformToString());
                break;
            }
            case LONG: {
                dataOutput.writeLong(((ConfigLong)configValue).unwrapped());
                dataOutput.writeUTF(((ConfigNumber)configValue).transformToString());
                break;
            }
            case DOUBLE: {
                dataOutput.writeDouble(((ConfigDouble)configValue).unwrapped());
                dataOutput.writeUTF(((ConfigNumber)configValue).transformToString());
                break;
            }
            case STRING: {
                dataOutput.writeUTF(((ConfigString)configValue).unwrapped());
                break;
            }
            case LIST: {
                ConfigList configList = (ConfigList)configValue;
                dataOutput.writeInt(configList.size());
                for (ConfigValue configValue2 : configList) {
                    SerializedConfigValue.writeValue(dataOutput, configValue2, (SimpleConfigOrigin)configList.origin());
                }
                break;
            }
            case OBJECT: {
                ConfigObject configObject = (ConfigObject)configValue;
                dataOutput.writeInt(configObject.size());
                for (Map.Entry entry : configObject.entrySet()) {
                    dataOutput.writeUTF((String)entry.getKey());
                    SerializedConfigValue.writeValue(dataOutput, (ConfigValue)entry.getValue(), (SimpleConfigOrigin)configObject.origin());
                }
                break;
            }
        }
    }

    private static AbstractConfigValue readValueData(DataInput dataInput, SimpleConfigOrigin simpleConfigOrigin) throws IOException {
        int n = dataInput.readUnsignedByte();
        SerializedValueType serializedValueType = SerializedValueType.forInt(n);
        if (serializedValueType == null) {
            throw new IOException("Unknown serialized value type: " + n);
        }
        switch (serializedValueType) {
            case BOOLEAN: {
                return new ConfigBoolean(simpleConfigOrigin, dataInput.readBoolean());
            }
            case NULL: {
                return new ConfigNull(simpleConfigOrigin);
            }
            case INT: {
                int n2 = dataInput.readInt();
                String string = dataInput.readUTF();
                return new ConfigInt(simpleConfigOrigin, n2, string);
            }
            case LONG: {
                long l = dataInput.readLong();
                String string = dataInput.readUTF();
                return new ConfigLong(simpleConfigOrigin, l, string);
            }
            case DOUBLE: {
                double d = dataInput.readDouble();
                String string = dataInput.readUTF();
                return new ConfigDouble(simpleConfigOrigin, d, string);
            }
            case STRING: {
                return new ConfigString(simpleConfigOrigin, dataInput.readUTF());
            }
            case LIST: {
                int n3 = dataInput.readInt();
                ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>(n3);
                for (int i = 0; i < n3; ++i) {
                    AbstractConfigValue abstractConfigValue = SerializedConfigValue.readValue(dataInput, simpleConfigOrigin);
                    arrayList.add(abstractConfigValue);
                }
                return new SimpleConfigList(simpleConfigOrigin, arrayList);
            }
            case OBJECT: {
                int n4 = dataInput.readInt();
                HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>(n4);
                for (int i = 0; i < n4; ++i) {
                    String string = dataInput.readUTF();
                    AbstractConfigValue abstractConfigValue = SerializedConfigValue.readValue(dataInput, simpleConfigOrigin);
                    hashMap.put(string, abstractConfigValue);
                }
                return new SimpleConfigObject(simpleConfigOrigin, hashMap);
            }
        }
        throw new IOException("Unhandled serialized value type: " + (Object)((Object)serializedValueType));
    }

    private static void writeValue(DataOutput dataOutput, ConfigValue configValue, SimpleConfigOrigin simpleConfigOrigin) throws IOException {
        FieldOut fieldOut = new FieldOut(SerializedField.VALUE_ORIGIN);
        SerializedConfigValue.writeOrigin(fieldOut.data, (SimpleConfigOrigin)configValue.origin(), simpleConfigOrigin);
        SerializedConfigValue.writeField(dataOutput, fieldOut);
        FieldOut fieldOut2 = new FieldOut(SerializedField.VALUE_DATA);
        SerializedConfigValue.writeValueData(fieldOut2.data, configValue);
        SerializedConfigValue.writeField(dataOutput, fieldOut2);
        SerializedConfigValue.writeEndMarker(dataOutput);
    }

    private static AbstractConfigValue readValue(DataInput dataInput, SimpleConfigOrigin simpleConfigOrigin) throws IOException {
        AbstractConfigValue abstractConfigValue = null;
        SimpleConfigOrigin simpleConfigOrigin2 = null;
        while (true) {
            SerializedField serializedField;
            if ((serializedField = SerializedConfigValue.readCode(dataInput)) == SerializedField.END_MARKER) {
                if (abstractConfigValue == null) {
                    throw new IOException("No value data found in serialization of value");
                }
                return abstractConfigValue;
            }
            if (serializedField == SerializedField.VALUE_DATA) {
                if (simpleConfigOrigin2 == null) {
                    throw new IOException("Origin must be stored before value data");
                }
                dataInput.readInt();
                abstractConfigValue = SerializedConfigValue.readValueData(dataInput, simpleConfigOrigin2);
                continue;
            }
            if (serializedField == SerializedField.VALUE_ORIGIN) {
                dataInput.readInt();
                simpleConfigOrigin2 = SerializedConfigValue.readOrigin(dataInput, simpleConfigOrigin);
                continue;
            }
            SerializedConfigValue.skipField(dataInput);
        }
    }

    private static void writeField(DataOutput dataOutput, FieldOut fieldOut) throws IOException {
        byte[] byArray = fieldOut.bytes.toByteArray();
        dataOutput.writeByte(fieldOut.code.ordinal());
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
    }

    private static void writeEndMarker(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(SerializedField.END_MARKER.ordinal());
    }

    private static SerializedField readCode(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if (n == SerializedField.UNKNOWN.ordinal()) {
            throw new IOException("field code " + n + " is not supposed to be on the wire");
        }
        return SerializedField.forInt(n);
    }

    private static void skipField(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.skipBytes(n);
        if (n2 < n) {
            byte[] byArray = new byte[n - n2];
            dataInput.readFully(byArray);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (((AbstractConfigValue)this.value).resolveStatus() != ResolveStatus.RESOLVED) {
            throw new NotSerializableException("tried to serialize a value with unresolved substitutions, need to Config#resolve() first, see API docs");
        }
        FieldOut fieldOut = new FieldOut(SerializedField.ROOT_VALUE);
        SerializedConfigValue.writeValue(fieldOut.data, this.value, null);
        SerializedConfigValue.writeField(objectOutput, fieldOut);
        fieldOut = new FieldOut(SerializedField.ROOT_WAS_CONFIG);
        fieldOut.data.writeBoolean(this.wasConfig);
        SerializedConfigValue.writeField(objectOutput, fieldOut);
        SerializedConfigValue.writeEndMarker(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        SerializedField serializedField;
        while ((serializedField = SerializedConfigValue.readCode(objectInput)) != SerializedField.END_MARKER) {
            if (serializedField == SerializedField.ROOT_VALUE) {
                objectInput.readInt();
                this.value = SerializedConfigValue.readValue(objectInput, null);
                continue;
            }
            if (serializedField == SerializedField.ROOT_WAS_CONFIG) {
                objectInput.readInt();
                this.wasConfig = objectInput.readBoolean();
                continue;
            }
            SerializedConfigValue.skipField(objectInput);
        }
        return;
    }

    private static ConfigException shouldNotBeUsed() {
        return new ConfigException.BugOrBroken(SerializedConfigValue.class.getName() + " should not exist outside of serialization");
    }

    @Override
    public ConfigValueType valueType() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public Object unwrapped() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    protected SerializedConfigValue newCopy(ConfigOrigin configOrigin) {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    private static class FieldOut {
        final SerializedField code;
        final ByteArrayOutputStream bytes;
        final DataOutput data;

        FieldOut(SerializedField serializedField) {
            this.code = serializedField;
            this.bytes = new ByteArrayOutputStream();
            this.data = new DataOutputStream(this.bytes);
        }
    }

    private static enum SerializedValueType {
        NULL(ConfigValueType.NULL),
        BOOLEAN(ConfigValueType.BOOLEAN),
        INT(ConfigValueType.NUMBER),
        LONG(ConfigValueType.NUMBER),
        DOUBLE(ConfigValueType.NUMBER),
        STRING(ConfigValueType.STRING),
        LIST(ConfigValueType.LIST),
        OBJECT(ConfigValueType.OBJECT);

        ConfigValueType configType;

        private SerializedValueType(ConfigValueType configValueType) {
            this.configType = configValueType;
        }

        static SerializedValueType forInt(int n) {
            if (n < SerializedValueType.values().length) {
                return SerializedValueType.values()[n];
            }
            return null;
        }

        static SerializedValueType forValue(ConfigValue configValue) {
            ConfigValueType configValueType = configValue.valueType();
            if (configValueType == ConfigValueType.NUMBER) {
                if (configValue instanceof ConfigInt) {
                    return INT;
                }
                if (configValue instanceof ConfigLong) {
                    return LONG;
                }
                if (configValue instanceof ConfigDouble) {
                    return DOUBLE;
                }
            } else {
                for (SerializedValueType serializedValueType : SerializedValueType.values()) {
                    if (serializedValueType.configType != configValueType) continue;
                    return serializedValueType;
                }
            }
            throw new ConfigException.BugOrBroken("don't know how to serialize " + configValue);
        }
    }

    static enum SerializedField {
        UNKNOWN,
        END_MARKER,
        ROOT_VALUE,
        ROOT_WAS_CONFIG,
        VALUE_DATA,
        VALUE_ORIGIN,
        ORIGIN_DESCRIPTION,
        ORIGIN_LINE_NUMBER,
        ORIGIN_END_LINE_NUMBER,
        ORIGIN_TYPE,
        ORIGIN_URL,
        ORIGIN_COMMENTS,
        ORIGIN_NULL_URL,
        ORIGIN_NULL_COMMENTS;


        static SerializedField forInt(int n) {
            if (n < SerializedField.values().length) {
                return SerializedField.values()[n];
            }
            return UNKNOWN;
        }
    }
}

