/*
 * Decompiled with CFR 0.152.
 */
package sbt.classfile;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import sbt.Using;
import sbt.Using$;
import sbt.classfile.AttributeInfo;
import sbt.classfile.ClassFile;
import sbt.classfile.Constant;
import sbt.classfile.FieldOrMethodInfo;
import sbt.classfile.Parser$;
import scala.Array$;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser$
implements ScalaObject {
    public static final Parser$ MODULE$;

    static {
        new Parser$();
    }

    public ClassFile apply(File file) {
        String string = file.getCanonicalPath();
        return (ClassFile)((Either)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(string){
            public static final long serialVersionUID;
            private final String eta$0$1$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Either<String, ClassFile> apply(InputStream inputStream) {
                return Parser$.MODULE$.sbt$classfile$Parser$$parse(this.eta$0$1$1, inputStream);
            }
            {
                this.eta$0$1$1 = string;
            }
        })).right().get();
    }

    public final Either<String, ClassFile> sbt$classfile$Parser$$parse(String fileName, InputStream is) {
        return new Right((Object)this.parseImpl(fileName, is));
    }

    private ClassFile parseImpl(String filename$1, InputStream is) {
        DataInputStream in$1 = new DataInputStream(is);
        return new ClassFile(filename$1, in$1){
            private final String fileName;
            private final int minorVersion;
            private final int majorVersion;
            private final Constant[] constantPool;
            private final int accessFlags;
            private final String className;
            private final String superClassName;
            private final String[] interfaceNames;
            private final FieldOrMethodInfo[] fields;
            private final FieldOrMethodInfo[] methods;
            private final AttributeInfo[] attributes;
            private Option<String> sourceFile;
            public final DataInputStream in$1;
            public volatile int bitmap$0;

            public String fileName() {
                return this.fileName;
            }

            public int minorVersion() {
                return this.minorVersion;
            }

            public int majorVersion() {
                return this.majorVersion;
            }

            public Constant[] constantPool() {
                return this.constantPool;
            }

            public int accessFlags() {
                return this.accessFlags;
            }

            public String className() {
                return this.className;
            }

            public String superClassName() {
                return this.superClassName;
            }

            public String[] interfaceNames() {
                return this.interfaceNames;
            }

            public FieldOrMethodInfo[] fields() {
                return this.fields;
            }

            public FieldOrMethodInfo[] methods() {
                return this.methods;
            }

            public AttributeInfo[] attributes() {
                return this.attributes;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Option<String> sourceFile() {
                if ((this.bitmap$0 & 1) != 0) return this.sourceFile;
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 1) == 0) {
                        this.sourceFile = Predef$.MODULE$.refArrayOps((Object[])this.attributes()).find((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(AttributeInfo attributeInfo) {
                                return attributeInfo.isSourceFile();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final anon.1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply(AttributeInfo sourceFileAttribute) {
                                return this.$outer.sbt$classfile$Parser$$anon$$toUTF8(Parser$.MODULE$.sbt$classfile$Parser$$entryIndex(sourceFileAttribute));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 1;
                    }
                    return this.sourceFile;
                }
            }

            public String stringValue(AttributeInfo a) {
                return this.sbt$classfile$Parser$$anon$$toUTF8(Parser$.MODULE$.sbt$classfile$Parser$$entryIndex(a));
            }

            private FieldOrMethodInfo[] readFieldsOrMethods() {
                return (FieldOrMethodInfo[])Parser$.MODULE$.sbt$classfile$Parser$$array(this.in$1.readUnsignedShort(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final FieldOrMethodInfo apply() {
                        return this.$outer.sbt$classfile$Parser$$anon$$parseFieldOrMethodInfo();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Manifest$.MODULE$.classType(FieldOrMethodInfo.class));
            }

            public final String sbt$classfile$Parser$$anon$$toUTF8(int entryIndex$1) {
                Constant entry2 = this.constantPool()[entryIndex$1];
                Predef$.MODULE$.assume(entry2.tag() == 1, (Function0)new Serializable(this, entryIndex$1){
                    public static final long serialVersionUID;
                    private final int entryIndex$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Constant pool entry is not a UTF8 type: ").append((Object)BoxesRunTime.boxToInteger((int)this.entryIndex$1)).toString();
                    }
                    {
                        this.entryIndex$1 = n;
                    }
                });
                return (String)entry2.value().get();
            }

            public final String sbt$classfile$Parser$$anon$$getClassConstantName(int entryIndex) {
                Constant entry2 = this.constantPool()[entryIndex];
                return entry2 == null ? "" : Parser$.MODULE$.sbt$classfile$Parser$$slashesToDots(this.sbt$classfile$Parser$$anon$$toUTF8(entry2.nameIndex()));
            }

            private Option<String> toString(int index) {
                return index <= 0 ? None$.MODULE$ : new Some((Object)this.sbt$classfile$Parser$$anon$$toUTF8(index));
            }

            public final FieldOrMethodInfo sbt$classfile$Parser$$anon$$parseFieldOrMethodInfo() {
                return new FieldOrMethodInfo(this.in$1.readUnsignedShort(), this.toString(this.in$1.readUnsignedShort()), this.toString(this.in$1.readUnsignedShort()), (IndexedSeq<AttributeInfo>)Predef$.MODULE$.wrapRefArray((Object[])Parser$.MODULE$.sbt$classfile$Parser$$array(this.in$1.readUnsignedShort(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final AttributeInfo apply() {
                        return this.$outer.sbt$classfile$Parser$$anon$$parseAttribute();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Manifest$.MODULE$.classType(AttributeInfo.class))));
            }

            public final AttributeInfo sbt$classfile$Parser$$anon$$parseAttribute() {
                int nameIndex = this.in$1.readUnsignedShort();
                None$ name = nameIndex == -1 ? None$.MODULE$ : new Some((Object)this.sbt$classfile$Parser$$anon$$toUTF8(nameIndex));
                byte[] value2 = (byte[])Parser$.MODULE$.sbt$classfile$Parser$$array(this.in$1.readInt(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return this.$outer.in$1.readByte();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Manifest$.MODULE$.Byte());
                return new AttributeInfo((Option<String>)name, value2);
            }

            public Set<String> types() {
                return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fieldTypes()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.methodTypes()), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).$plus$plus(this.classConstantReferences(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))));
            }

            private String[] getTypes(FieldOrMethodInfo[] fieldsOrMethods) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])fieldsOrMethods).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final List<String> apply(FieldOrMethodInfo fieldOrMethod) {
                        return Parser$.MODULE$.sbt$classfile$Parser$$descriptorToTypes(fieldOrMethod.descriptor());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)));
            }

            private String[] fieldTypes() {
                return this.getTypes(this.fields());
            }

            private String[] methodTypes() {
                return this.getTypes(this.methods());
            }

            private List<String> classConstantReferences() {
                return (List)this.constants().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final List<String> apply(Constant constant2) {
                        List list;
                        byte by = constant2.tag();
                        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToByte((byte)by))) {
                            String name = this.$outer.sbt$classfile$Parser$$anon$$toUTF8(constant2.nameIndex());
                            if (name.startsWith("[")) {
                                list = Parser$.MODULE$.sbt$classfile$Parser$$descriptorToTypes((Option<String>)new Some((Object)name));
                            } else {
                                String string = Parser$.MODULE$.sbt$classfile$Parser$$slashesToDots(name);
                                list = Nil$.MODULE$.$colon$colon((Object)string);
                            }
                        } else {
                            list = Nil$.MODULE$;
                        }
                        return list;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            private List<Constant> constants() {
                return this.next$1(1, (List)Nil$.MODULE$);
            }

            private final List next$1(int i, List list) {
                while (i < this.constantPool().length) {
                    Constant constant2;
                    Constant constant3 = constant2;
                    list = list.$colon$colon((Object)constant3);
                    constant2 = this.constantPool()[i];
                    i = constant2.wide() ? i + 2 : i + 1;
                }
                return list;
            }
            {
                this.in$1 = dataInputStream;
                Predef$.MODULE$.assume(dataInputStream.readInt() == -889275714, (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Invalid class file: ").append((Object)this.$outer.fileName()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.fileName = string;
                this.minorVersion = dataInputStream.readUnsignedShort();
                this.majorVersion = dataInputStream.readUnsignedShort();
                this.constantPool = Parser$.MODULE$.sbt$classfile$Parser$$parseConstantPool(dataInputStream);
                this.accessFlags = dataInputStream.readUnsignedShort();
                this.className = this.sbt$classfile$Parser$$anon$$getClassConstantName(dataInputStream.readUnsignedShort());
                this.superClassName = this.sbt$classfile$Parser$$anon$$getClassConstantName(dataInputStream.readUnsignedShort());
                this.interfaceNames = (String[])Parser$.MODULE$.sbt$classfile$Parser$$array(dataInputStream.readUnsignedShort(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.$outer.sbt$classfile$Parser$$anon$$getClassConstantName(this.$outer.in$1.readUnsignedShort());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Manifest$.MODULE$.classType(String.class));
                this.fields = this.readFieldsOrMethods();
                this.methods = this.readFieldsOrMethods();
                this.attributes = (AttributeInfo[])Parser$.MODULE$.sbt$classfile$Parser$$array(dataInputStream.readUnsignedShort(), new Serializable(this){
                    public static final long serialVersionUID;
                    private final anon.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final AttributeInfo apply() {
                        return this.$outer.sbt$classfile$Parser$$anon$$parseAttribute();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Manifest$.MODULE$.classType(AttributeInfo.class));
            }
        };
    }

    public final <T> Object sbt$classfile$Parser$$array(int size, Function0<T> f$1, Manifest<T> evidence$1) {
        return Array$.MODULE$.tabulate(size, (Function1)new Serializable(f$1){
            public static final long serialVersionUID;
            private final Function0 f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply(int x$4) {
                return (T)this.f$1.apply();
            }
            {
                this.f$1 = function0;
            }
        }, evidence$1);
    }

    /*
     * WARNING - void declaration
     */
    public final Constant[] sbt$classfile$Parser$$parseConstantPool(DataInputStream in$2) {
        void var3_3;
        int constantPoolSize$1 = in$2.readUnsignedShort();
        Constant[] pool$1 = new Constant[constantPoolSize$1];
        this.parse$1(1, in$2, constantPoolSize$1, pool$1);
        return var3_3;
    }

    private Constant getConstant(DataInputStream in) {
        Constant constant2;
        byte tag;
        byte by = tag = in.readByte();
        switch (by) {
            default: {
                throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Unknown constant: ").append((Object)BoxesRunTime.boxToByte((byte)tag)).toString());
            }
            case 4: {
                constant2 = new Constant(tag, new Float(in.readFloat()));
                break;
            }
            case 3: {
                constant2 = new Constant(tag, new Integer(in.readInt()));
                break;
            }
            case 7: 
            case 8: {
                constant2 = new Constant(tag, in.readUnsignedShort());
                break;
            }
            case 6: {
                constant2 = new Constant(tag, new Double(in.readDouble()));
                break;
            }
            case 1: {
                constant2 = new Constant(tag, in.readUTF());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                constant2 = new Constant(tag, in.readUnsignedShort(), in.readUnsignedShort());
                break;
            }
            case 5: {
                constant2 = new Constant(tag, new Long(in.readLong()));
            }
        }
        return constant2;
    }

    private int toInt(byte v) {
        return v < 0 ? v + 256 : v;
    }

    public final int sbt$classfile$Parser$$entryIndex(AttributeInfo a) {
        byte[] byArray = a.value();
        Option option = Array$.MODULE$.unapplySeq((Object)byArray);
        if (option.isEmpty()) {
            throw new MatchError((Object)byArray);
        }
        IndexedSeq indexedSeq = (IndexedSeq)option.get();
        if (indexedSeq == null ? false : indexedSeq.lengthCompare(2) == 0) {
            Tuple2 tuple2 = new Tuple2(indexedSeq.apply(0), indexedSeq.apply(1));
            byte v0 = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte v1 = BoxesRunTime.unboxToByte((Object)tuple2._2());
            return this.toInt(v0) * 256 + this.toInt(v1);
        }
        throw new MatchError((Object)byArray);
    }

    public final String sbt$classfile$Parser$$slashesToDots(String s) {
        return s.replace('/', '.');
    }

    public final List<String> sbt$classfile$Parser$$descriptorToTypes(Option<String> descriptor) {
        return this.toTypes$1((String)descriptor.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "";
            }
        }), (List)Nil$.MODULE$);
    }

    private final void parse$1(int i, DataInputStream dataInputStream, int n, Constant[] constantArray) {
        while (i < n) {
            Constant constant2;
            constantArray[i] = constant2 = this.getConstant(dataInputStream);
            i = constant2.wide() ? i + 2 : i + 1;
        }
    }

    private final List toTypes$1(String descriptor, List types2) {
        int startIndex;
        while ((startIndex = descriptor.indexOf(76)) >= 0) {
            String tpe2;
            int endIndex = descriptor.indexOf(59, startIndex + 1);
            String string = tpe2 = this.sbt$classfile$Parser$$slashesToDots(descriptor.substring(startIndex + 1, endIndex));
            types2 = types2.$colon$colon((Object)string);
            descriptor = descriptor.substring(endIndex);
        }
        return types2;
    }

    private Parser$() {
        MODULE$ = this;
    }
}

