/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import jline.Terminal;
import sbt.ConsoleLogger;
import sbt.ConsoleLogger$;
import sbt.ConsoleOut;
import sbt.SuppressedTraceContext;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleLogger$
implements ScalaObject {
    public static final ConsoleLogger$ MODULE$;
    private final char ESC;
    private final String OverwriteLine;
    private final boolean formatEnabled;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final Regex EscapeSequence;

    static {
        new ConsoleLogger$();
    }

    public ConsoleOut systemOut() {
        return this.printStreamOut(System.out);
    }

    public Function2<String, String, Object> overwriteContaining(String s$1) {
        return new Serializable(s$1){
            public static final long serialVersionUID;
            private final String s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String cur, String prev) {
                return cur.contains(this.s$1) && prev.contains(this.s$1);
            }
            {
                this.s$1 = string;
            }
        };
    }

    public ConsoleOut systemOutOverwrite(Function2<String, String, Object> f$1) {
        return new ConsoleOut(f$1){
            private final PrintStream lockObject;
            private Option<String> last;
            private StringBuffer current;
            public final Function2 f$1;

            public PrintStream lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                anon.1 var2_2 = this;
                synchronized (var2_2) {
                    this.current.append(s);
                    return;
                }
            }

            public void println(String s) {
                anon.1 var2_2 = this;
                synchronized (var2_2) {
                    this.current.append(s);
                    this.println();
                    return;
                }
            }

            public void println() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    String s$2 = this.current.toString();
                    if (ConsoleLogger$.MODULE$.formatEnabled() && this.last.exists((Function1)new Serializable(this, s$2){
                        public static final long serialVersionUID;
                        private final anon.1 $outer;
                        private final String s$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(String lmsg) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.f$1.apply((Object)this.s$2, (Object)lmsg));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.s$2 = string;
                        }
                    })) {
                        System.out.print("\r\u001bM\u001b[2K");
                    }
                    System.out.println(s$2);
                    this.last = new Some((Object)s$2);
                    this.current = new StringBuffer();
                    return;
                }
            }
            {
                this.f$1 = function2;
                this.lockObject = System.out;
                this.last = None$.MODULE$;
                this.current = new StringBuffer();
            }
        };
    }

    public ConsoleOut printStreamOut(PrintStream out$1) {
        return new ConsoleOut(out$1){
            private final PrintStream lockObject;
            private final PrintStream out$1;

            public PrintStream lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$1.print(s);
            }

            public void println(String s) {
                this.out$1.println(s);
            }

            public void println() {
                this.out$1.println();
            }
            {
                this.out$1 = printStream;
                this.lockObject = printStream;
            }
        };
    }

    public ConsoleOut printWriterOut(PrintWriter out$2) {
        return new ConsoleOut(out$2){
            private final PrintWriter lockObject;
            private final PrintWriter out$2;

            public PrintWriter lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$2.print(s);
            }

            public void println(String s) {
                this.out$2.println(s);
                this.out$2.flush();
            }

            public void println() {
                this.out$2.println();
                this.out$2.flush();
            }
            {
                this.out$2 = printWriter;
                this.lockObject = printWriter;
            }
        };
    }

    public ConsoleOut bufferedWriterOut(BufferedWriter out$3) {
        return new ConsoleOut(out$3){
            private final BufferedWriter lockObject;
            private final BufferedWriter out$3;

            public BufferedWriter lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$3.write(s);
            }

            public void println(String s) {
                this.out$3.write(s);
                this.println();
            }

            public void println() {
                this.out$3.newLine();
                this.out$3.flush();
            }
            {
                this.out$3 = bufferedWriter;
                this.lockObject = bufferedWriter;
            }
        };
    }

    public final char ESC() {
        return '\u001b';
    }

    public final String OverwriteLine() {
        return "\r\u001bM\u001b[2K";
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    public boolean hasEscapeSequence(String s) {
        return s.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s) {
        String string;
        if (!s.isEmpty() && this.hasEscapeSequence(s)) {
            StringBuilder sb = new StringBuilder();
            this.nextESC(s, 0, sb);
            string = sb.toString();
        } else {
            string = s;
        }
        return string;
    }

    private void nextESC(String s, int start, StringBuilder sb) {
        while (true) {
            int next2;
            int escIndex;
            if ((escIndex = s.indexOf(27, start)) < 0) {
                sb.append(s, start, s.length());
                return;
            }
            sb.append(s, start, escIndex);
            start = next2 = this.skipESC(s, escIndex + 1);
        }
    }

    private int skipESC(String s, int i) {
        while (true) {
            block5: {
                int n;
                block4: {
                    block3: {
                        if (i < s.length()) break block3;
                        n = i;
                        break block4;
                    }
                    if (!this.isEscapeTerminator(s.charAt(i))) break block5;
                    n = i + 1;
                }
                return n;
            }
            ++i;
        }
    }

    public boolean formatEnabled() {
        return this.formatEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean ansiSupported() {
        void var1_1;
        boolean exceptionResult1 = false;
        try {
            Terminal terminal = Terminal.getTerminal();
            terminal.enableEcho();
            exceptionResult1 = terminal.isANSISupported();
        }
        catch (Exception exception) {
            exceptionResult1 = !this.isWindows();
        }
        return (boolean)var1_1;
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase().indexOf("windows") >= 0;
    }

    public ConsoleLogger apply(PrintStream out) {
        return this.apply(this.printStreamOut(out), this.apply$default$2(), this.apply$default$3(), (Function1<SuppressedTraceContext, Option<String>>)this.apply$default$4());
    }

    public ConsoleLogger apply(PrintWriter out) {
        return this.apply(this.printWriterOut(out), this.apply$default$2(), this.apply$default$3(), (Function1<SuppressedTraceContext, Option<String>>)this.apply$default$4());
    }

    public ConsoleLogger apply(ConsoleOut out, boolean ansiCodesSupported, boolean useColor, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleLogger(out, ansiCodesSupported, useColor, suppressedMessage);
    }

    public Function1 apply$default$4() {
        return this.noSuppressedMessage();
    }

    public boolean apply$default$3() {
        return this.formatEnabled();
    }

    public boolean apply$default$2() {
        return this.formatEnabled();
    }

    public ConsoleOut apply$default$1() {
        return this.systemOut();
    }

    public String stripEscapeSequences(String s) {
        return this.EscapeSequence.pattern().matcher(s).replaceAll("");
    }

    private ConsoleLogger$() {
        MODULE$ = this;
        String value2 = System.getProperty("sbt.log.format");
        this.formatEnabled = value2 == null ? this.ansiSupported() && !Boolean.getBoolean("sbt.log.noformat") : Boolean.parseBoolean(value2);
        this.noSuppressedMessage = new anonfun.1();
        this.EscapeSequence = Predef$.MODULE$.augmentString(new scala.collection.mutable.StringBuilder().append((char)27).append((Object)"[^@-~]*[@-~]").toString()).r();
    }
}

