/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.AbstractLogger;
import sbt.BasicLogger;
import sbt.ControlEvent;
import sbt.Level$;
import sbt.Log;
import sbt.LogEvent;
import sbt.SetLevel;
import sbt.SetSuccess;
import sbt.SetTrace;
import sbt.Success;
import sbt.Trace;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001\u0015\u0011aBQ;gM\u0016\u0014X\r\u001a'pO\u001e,'OC\u0001\u0004\u0003\r\u0019(\r^\u0002\u0001'\r\u0001aA\u0003\t\u0003\u000f!i\u0011AA\u0005\u0003\u0013\t\u00111BQ1tS\u000edunZ4feB\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012\u0001\u00033fY\u0016<\u0017\r^3\u0011\u0005\u001d\u0019\u0012B\u0001\u000b\u0003\u00059\t%m\u001d;sC\u000e$Hj\\4hKJDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtDC\u0001\r\u001a!\t9\u0001\u0001C\u0003\u0012+\u0001\u0007!\u0003\u0003\u0004\u001c\u0001\u0001\u0006I\u0001H\u0001\u0007EV4g-\u001a:\u0011\u0007u\u0011C%D\u0001\u001f\u0015\ty\u0002%A\u0004nkR\f'\r\\3\u000b\u0005\u0005b\u0011AC2pY2,7\r^5p]&\u00111E\b\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA\u0004&\u0013\t1#A\u0001\u0005M_\u001e,e/\u001a8u\u0011\u0019A\u0003\u0001)Q\u0005S\u0005I!/Z2pe\u0012Lgn\u001a\t\u0003\u0017)J!a\u000b\u0007\u0003\u000f\t{w\u000e\\3b]\")Q\u0006\u0001C\u0001]\u00051!/Z2pe\u0012$\u0012a\f\t\u0003\u0017AJ!!\r\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u00067\u0001!\taM\u000b\u0003i]\"\"!\u000e!\u0011\u0005Y:D\u0002\u0001\u0003\u0006qI\u0012\r!\u000f\u0002\u0002)F\u0011!(\u0010\t\u0003\u0017mJ!\u0001\u0010\u0007\u0003\u000f9{G\u000f[5oOB\u00111BP\u0005\u0003\u007f1\u00111!\u00118z\u0011\u0019\t%\u0007\"a\u0001\u0005\u0006\ta\rE\u0002\f\u0007VJ!\u0001\u0012\u0007\u0003\u0011q\u0012\u0017P\\1nKzBQA\u0012\u0001\u0005\u0002\u001d\u000bQBY;gM\u0016\u0014\u0018+^5fi2LXC\u0001%K)\tI5\n\u0005\u00027\u0015\u0012)\u0001(\u0012b\u0001s!1\u0011)\u0012CA\u00021\u00032aC\"J\u0011\u0015q\u0005\u0001\"\u0001/\u0003-\u0019Ho\u001c9Rk&,G\u000f\\=\t\u000bA\u0003A\u0011\u0001\u0018\u0002\tAd\u0017-\u001f\u0005\u0006%\u0002!\tAL\u0001\u0006G2,\u0017M\u001d\u0005\u0006)\u0002!\tAL\u0001\u0005gR|\u0007\u000fC\u0003W\u0001\u0011\u0005s+\u0001\nb]NL7i\u001c3fgN+\b\u000f]8si\u0016$W#A\u0015\t\u000be\u0003A\u0011\t.\u0002\u0011M,G\u000fT3wK2$\"aL.\t\u000bqC\u0006\u0019A/\u0002\u00119,w\u000fT3wK2\u0004\"AX1\u000f\u0005\u001dy\u0016B\u00011\u0003\u0003\u0015aUM^3m\u0013\t\u00117MA\u0003WC2,X-\u0003\u0002e\u0019\tYQI\\;nKJ\fG/[8o\u0011\u00151\u0007\u0001\"\u0011h\u0003E\u0019X\r^*vG\u000e,7o]#oC\ndW\r\u001a\u000b\u0003_!DQ![3A\u0002%\nAA\u001a7bO\")1\u000e\u0001C!Y\u0006A1/\u001a;Ue\u0006\u001cW\r\u0006\u00020[\")aN\u001ba\u0001_\u0006)A.\u001a<fYB\u00111\u0002]\u0005\u0003c2\u00111!\u00138u\u0011\u0015\u0019\b\u0001\"\u0001u\u0003\u0015!(/Y2f)\tyS\u000f\u0003\u0004we\u0012\u0005\ra^\u0001\u0002iB\u00191b\u0011=\u0011\u0007e\f\u0019A\u0004\u0002{\u007f:\u00111P`\u0007\u0002y*\u0011Q\u0010B\u0001\u0007yI|w\u000e\u001e \n\u00035I1!!\u0001\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0002\u0002\b\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003a\u0001bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\bgV\u001c7-Z:t)\ry\u0013q\u0002\u0005\n\u0003#\tI\u0001\"a\u0001\u0003'\tq!\\3tg\u0006<W\r\u0005\u0003\f\u0007\u0006U\u0001\u0003BA\f\u0003;q1aCA\r\u0013\r\tY\u0002D\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0011\u0011\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mA\u0002C\u0004\u0002&\u0001!\t!a\n\u0002\u00071|w\rF\u00030\u0003S\tY\u0003\u0003\u0004o\u0003G\u0001\r!\u0018\u0005\n\u0003#\t\u0019\u0003\"a\u0001\u0003'Aq!a\f\u0001\t\u0003\t\t$\u0001\u0004m_\u001e\fE\u000e\u001c\u000b\u0004_\u0005M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\r\u00154XM\u001c;t!\u0011I\u0018\u0011\b\u0013\n\t\u0005m\u0012q\u0001\u0002\u0004'\u0016\f\bbBA \u0001\u0011\u0005\u0011\u0011I\u0001\bG>tGO]8m)\u0015y\u00131IA(\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013!B3wK:$\bcAA%C:\u0019q!a\u0013\n\u0007\u00055#!\u0001\u0007D_:$(o\u001c7Fm\u0016tG\u000fC\u0005\u0002\u0012\u0005uB\u00111\u0001\u0002\u0014!9\u00111\u000b\u0001\u0005\n\u0005U\u0013\u0001\u00043p\u0005V4g-\u001a:bE2,GcB\u0018\u0002X\u0005e\u0013q\f\u0005\u0007]\u0006E\u0003\u0019A/\t\u0013\u0005m\u0013\u0011\u000bCA\u0002\u0005u\u0013\u0001E1qa\u0016tG-\u00134Ck\u001a4WM]3e!\rY1\t\n\u0005\t\u0003C\n\t\u00061\u0001\u0002d\u0005aAm\\+oEV4g-\u001a:fIB)1\"!\u001a\u0013_%\u0019\u0011q\r\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA6\u0001\u0011%\u0011QN\u0001\u000fI>\u0014UO\u001a4fe\u0006\u0014G.Z%g)\u001dy\u0013qNA;\u0003oB\u0011\"!\u001d\u0002j\u0011\u0005\r!a\u001d\u0002\u0013\r|g\u000eZ5uS>t\u0007cA\u0006DS!I\u00111LA5\t\u0003\u0007\u0011Q\f\u0005\t\u0003C\nI\u00071\u0001\u0002d\u0001")
public class BufferedLogger
extends BasicLogger
implements ScalaObject {
    private final AbstractLogger delegate;
    private final ListBuffer<LogEvent> buffer;
    private boolean recording;

    public void record() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.recording = true;
            return;
        }
    }

    public <T> T buffer(Function0<T> f) {
        this.record();
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = f.apply();
            return (T)exceptionResult1;
        }
        finally {
            this.stopQuietly();
        }
    }

    public <T> T bufferQuietly(Function0<T> f) {
        this.record();
        Object exceptionResult2 = null;
        try {
            Object result = f.apply();
            this.clear();
            exceptionResult2 = result;
        }
        catch (Throwable throwable) {
            this.stopQuietly();
            throw throwable;
        }
        return (T)exceptionResult2;
    }

    public void stopQuietly() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.liftedTree1$1();
            return;
        }
    }

    public void play() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.delegate.logAll((Seq<LogEvent>)this.buffer.readOnly());
            this.buffer.clear();
            return;
        }
    }

    public void clear() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.buffer.clear();
            this.recording = false;
            return;
        }
    }

    public void stop() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.play();
            this.clear();
            return;
        }
    }

    @Override
    public boolean ansiCodesSupported() {
        return this.delegate.ansiCodesSupported();
    }

    @Override
    public void setLevel(Enumeration.Value newLevel) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            super.setLevel(newLevel);
            if (this.recording) {
                boxedUnit = this.buffer.$plus$eq((Object)new SetLevel(newLevel));
            } else {
                this.delegate.setLevel(newLevel);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void setSuccessEnabled(boolean flag) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            super.setSuccessEnabled(flag);
            if (this.recording) {
                boxedUnit = this.buffer.$plus$eq((Object)new SetSuccess(flag));
            } else {
                this.delegate.setSuccessEnabled(flag);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void setTrace(int level) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            super.setTrace(level);
            if (this.recording) {
                boxedUnit = this.buffer.$plus$eq((Object)new SetTrace(level));
            } else {
                this.delegate.setTrace(level);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void trace(Function0<Throwable> t$1) {
        this.doBufferableIf((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID;
            private final BufferedLogger $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.traceEnabled();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<LogEvent>)new Serializable(this, t$1){
            public static final long serialVersionUID;
            private final Function0 t$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Trace apply() {
                return new Trace((Throwable)this.t$1.apply());
            }
            {
                this.t$1 = function0;
            }
        }, (Function1<AbstractLogger, BoxedUnit>)new Serializable(this, t$1){
            public static final long serialVersionUID;
            private final Function0 t$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AbstractLogger abstractLogger) {
                abstractLogger.trace((Function0<Throwable>)this.t$1);
            }
            {
                this.t$1 = function0;
            }
        });
    }

    @Override
    public void success(Function0<String> message$1) {
        this.doBufferable(Level$.MODULE$.Info(), (Function0<LogEvent>)new Serializable(this, message$1){
            public static final long serialVersionUID;
            private final Function0 message$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Success apply() {
                return new Success((String)this.message$1.apply());
            }
            {
                this.message$1 = function0;
            }
        }, (Function1<AbstractLogger, BoxedUnit>)new Serializable(this, message$1){
            public static final long serialVersionUID;
            private final Function0 message$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AbstractLogger abstractLogger) {
                abstractLogger.success((Function0<String>)this.message$1);
            }
            {
                this.message$1 = function0;
            }
        });
    }

    @Override
    public void log(Enumeration.Value level$2, Function0<String> message$2) {
        this.doBufferable(level$2, (Function0<LogEvent>)new Serializable(this, level$2, message$2){
            public static final long serialVersionUID;
            private final Enumeration.Value level$2;
            private final Function0 message$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Log apply() {
                return new Log(this.level$2, (String)this.message$2.apply());
            }
            {
                this.level$2 = value2;
                this.message$2 = function0;
            }
        }, (Function1<AbstractLogger, BoxedUnit>)new Serializable(this, level$2, message$2){
            public static final long serialVersionUID;
            private final Enumeration.Value level$2;
            private final Function0 message$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AbstractLogger abstractLogger) {
                abstractLogger.log(this.level$2, (Function0<String>)this.message$2);
            }
            {
                this.level$2 = value2;
                this.message$2 = function0;
            }
        });
    }

    @Override
    public void logAll(Seq<LogEvent> events) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            ListBuffer listBuffer;
            if (this.recording) {
                listBuffer = this.buffer.$plus$plus$eq(events);
            } else {
                this.delegate.logAll(events);
                listBuffer = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void control(Enumeration.Value event$1, Function0<String> message$3) {
        this.doBufferable(Level$.MODULE$.Info(), (Function0<LogEvent>)new Serializable(this, event$1, message$3){
            public static final long serialVersionUID;
            private final Enumeration.Value event$1;
            private final Function0 message$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ControlEvent apply() {
                return new ControlEvent(this.event$1, (String)this.message$3.apply());
            }
            {
                this.event$1 = value2;
                this.message$3 = function0;
            }
        }, (Function1<AbstractLogger, BoxedUnit>)new Serializable(this, event$1, message$3){
            public static final long serialVersionUID;
            private final Enumeration.Value event$1;
            private final Function0 message$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AbstractLogger abstractLogger) {
                abstractLogger.control(this.event$1, (Function0<String>)this.message$3);
            }
            {
                this.event$1 = value2;
                this.message$3 = function0;
            }
        });
    }

    private void doBufferable(Enumeration.Value level$1, Function0<LogEvent> appendIfBuffered, Function1<AbstractLogger, BoxedUnit> doUnbuffered) {
        this.doBufferableIf((Function0<Object>)new Serializable(this, level$1){
            public static final long serialVersionUID;
            private final BufferedLogger $outer;
            private final Enumeration.Value level$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.atLevel(this.level$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.level$1 = value2;
            }
        }, appendIfBuffered, doUnbuffered);
    }

    private void doBufferableIf(Function0<Object> condition, Function0<LogEvent> appendIfBuffered, Function1<AbstractLogger, BoxedUnit> doUnbuffered) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            Object object = condition.apply$mcZ$sp() ? (this.recording ? this.buffer.$plus$eq(appendIfBuffered.apply()) : doUnbuffered.apply((Object)this.delegate)) : BoxedUnit.UNIT;
            return;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedLogger(AbstractLogger delegate) {
        this.delegate = delegate;
        this.buffer = new ListBuffer();
        this.recording = false;
    }
}

