/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.spi.service.ServiceFinder;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.client.ClientFactory;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.junit.After;
import org.junit.Before;

public abstract class JerseyTest {
    private static Class<? extends TestContainerFactory> defaultTestContainerFactoryClass;
    private TestContainerFactory testContainerFactory;
    private ClientFactory clientFactory;
    private final TestContainer tc;
    private final Client client;
    private static final String DEFAULT_TEST_CONTAINER_FACTORY_CLASS_NAME = "com.sun.jersey.test.framework.spi.container.grizzly2.web.GrizzlyWebTestContainerFactory";
    @Deprecated
    private static final String TEST_CONTAINER_FACTORY_PROPERTY_NAME_LEGACY = "test.containerFactory";
    private static final String TEST_CONTAINER_FACTORY_PROPERTY_NAME = "jersey.test.containerFactory";

    public JerseyTest() throws TestContainerException {
        AppDescriptor ad = this.configure();
        this.tc = this.getContainer(ad, this.getTestContainerFactory());
        this.client = this.getClient(this.tc, ad);
    }

    public JerseyTest(TestContainerFactory testContainerFactory) {
        this.setTestContainerFactory(testContainerFactory);
        AppDescriptor ad = this.configure();
        this.tc = this.getContainer(ad, this.getTestContainerFactory());
        this.client = this.getClient(this.tc, ad);
    }

    protected AppDescriptor configure() {
        throw new UnsupportedOperationException("The configure method must be implemented by the extending class");
    }

    public JerseyTest(AppDescriptor ad) throws TestContainerException {
        this.tc = this.getContainer(ad, this.getTestContainerFactory());
        this.client = this.getClient(this.tc, ad);
    }

    public JerseyTest(String ... packages) throws TestContainerException {
        this(new WebAppDescriptor.Builder(packages).build());
    }

    protected void setTestContainerFactory(TestContainerFactory testContainerFactory) {
        this.testContainerFactory = testContainerFactory;
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = JerseyTest.getDefaultTestContainerFactory();
        }
        return this.testContainerFactory;
    }

    public WebResource resource() {
        return this.client.resource(this.tc.getBaseUri());
    }

    public Client client() {
        return this.client;
    }

    @Before
    public void setUp() throws Exception {
        this.tc.start();
    }

    @After
    public void tearDown() throws Exception {
        this.tc.stop();
    }

    private TestContainer getContainer(AppDescriptor ad, TestContainerFactory tcf) {
        if (ad == null) {
            throw new IllegalArgumentException("The application descriptor cannot be null");
        }
        Class adType = tcf.supports();
        if (adType == LowLevelAppDescriptor.class && ad.getClass() == WebAppDescriptor.class) {
            ad = LowLevelAppDescriptor.transform((WebAppDescriptor)ad);
        } else if (adType != ad.getClass()) {
            throw new TestContainerException("The application descriptor type, " + ad.getClass() + ", is not supported by the test container factory, " + tcf);
        }
        return tcf.create(this.getBaseURI(), ad);
    }

    private static TestContainerFactory getDefaultTestContainerFactory() {
        if (defaultTestContainerFactoryClass == null) {
            if (System.getProperty(TEST_CONTAINER_FACTORY_PROPERTY_NAME) == null && System.getProperty(TEST_CONTAINER_FACTORY_PROPERTY_NAME_LEGACY) == null) {
                TestContainerFactory[] resultArray = (TestContainerFactory[])ServiceFinder.find(TestContainerFactory.class).toArray();
                if (resultArray.length >= 1) {
                    for (int i = 0; i < resultArray.length; ++i) {
                        if (!resultArray[i].getClass().getName().equals(DEFAULT_TEST_CONTAINER_FACTORY_CLASS_NAME)) continue;
                        Logger.getLogger(TestContainerFactory.class.getName()).config("Found multiple TestContainerFactory implementations, using default " + resultArray[i].getClass().getName());
                        defaultTestContainerFactoryClass = resultArray[i].getClass();
                        return resultArray[i];
                    }
                    if (resultArray.length != 1) {
                        Logger.getLogger(TestContainerFactory.class.getName()).warning("Found multiple TestContainerFactory implementations, using " + resultArray[0].getClass().getName());
                    }
                    defaultTestContainerFactoryClass = resultArray[0].getClass();
                    return resultArray[0];
                }
            } else {
                String tcfClassName = System.getProperty(TEST_CONTAINER_FACTORY_PROPERTY_NAME);
                if (tcfClassName == null) {
                    tcfClassName = System.getProperty(TEST_CONTAINER_FACTORY_PROPERTY_NAME_LEGACY, DEFAULT_TEST_CONTAINER_FACTORY_CLASS_NAME);
                }
                try {
                    defaultTestContainerFactoryClass = Class.forName(tcfClassName).asSubclass(TestContainerFactory.class);
                }
                catch (ClassNotFoundException ex) {
                    throw new TestContainerException("The default test container factory class name, " + tcfClassName + ", cannot be loaded", ex);
                }
                catch (ClassCastException ex) {
                    throw new TestContainerException("The default test container factory class, " + tcfClassName + ", is not an instance of TestContainerFactory", ex);
                }
            }
        }
        try {
            return defaultTestContainerFactoryClass.newInstance();
        }
        catch (Exception ex) {
            throw new TestContainerException("The default test container factory, " + defaultTestContainerFactoryClass + ", could not be instantiated", ex);
        }
    }

    protected Client getClient(TestContainer tc, AppDescriptor ad) {
        boolean enableLogging;
        Client c = tc.getClient();
        if (c != null) {
            return c;
        }
        c = this.getClientFactory().create(ad.getClientConfig());
        boolean bl = enableLogging = System.getProperty("enableLogging") != null;
        if (enableLogging) {
            c.addFilter((ClientFilter)new LoggingFilter());
        }
        return c;
    }

    protected ClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = JerseyTest.getDefaultClientFactory();
        }
        return this.clientFactory;
    }

    private static ClientFactory getDefaultClientFactory() {
        return new ClientFactory(){

            @Override
            public Client create(ClientConfig cc) {
                return Client.create((ClientConfig)cc);
            }
        };
    }

    protected void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(this.getPort(9998)).build(new Object[0]);
    }

    protected int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new TestContainerException("jersey.test.port with a value of \"" + port + "\" is not a valid integer.", e);
            }
        }
        port = System.getProperty("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new TestContainerException("JERSEY_HTTP_PORT with a value of \"" + port + "\" is not a valid integer.", e);
            }
        }
        return defaultPort;
    }
}

