/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.SdkParser;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DefaultSdkParser
implements SdkParser {
    private final String mSdkLocation;
    private SdkManager mManager;
    private IAndroidTarget mTarget;
    private BuildToolInfo mBuildToolInfo;
    private File mTools;
    private File mPlatformTools;
    private File mAdb;
    private File mZipAlign;

    public DefaultSdkParser(@NonNull String sdkLocation) {
        this.mSdkLocation = !sdkLocation.endsWith(File.separator) ? sdkLocation + File.separator : sdkLocation;
    }

    @Override
    public void initParser(@NonNull String target, @NonNull FullRevision buildToolRevision, @NonNull ILogger logger) {
        if (this.mManager == null) {
            this.mManager = SdkManager.createManager((String)this.mSdkLocation, (ILogger)logger);
            if (this.mManager == null) {
                throw new IllegalStateException("failed to parse SDK!");
            }
            this.mTarget = this.mManager.getTargetFromHashString(target);
            if (this.mTarget == null) {
                throw new IllegalStateException("failed to find target " + target);
            }
            this.mBuildToolInfo = this.mManager.getBuildTool(buildToolRevision);
            if (this.mBuildToolInfo == null) {
                throw new IllegalStateException("failed to find Build Tools revision " + buildToolRevision.toString());
            }
        }
    }

    @Override
    @NonNull
    public IAndroidTarget getTarget() {
        if (this.mManager == null) {
            throw new IllegalStateException("SdkParser was not initialized.");
        }
        return this.mTarget;
    }

    @Override
    @NonNull
    public BuildToolInfo getBuildTools() {
        if (this.mManager == null) {
            throw new IllegalStateException("SdkParser was not initialized.");
        }
        return this.mBuildToolInfo;
    }

    @Override
    @NonNull
    public String getAnnotationsJar() {
        return this.mSdkLocation + "tools" + '/' + "support" + '/' + "annotations.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public FullRevision getPlatformToolsRevision() {
        FullRevision fullRevision;
        File platformTools = this.getPlatformToolsFolder();
        if (!platformTools.isDirectory()) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(platformTools, "source.properties")), Charsets.UTF_8);
            Properties props = new Properties();
            props.load(reader);
            String value = props.getProperty("Pkg.Revision");
            fullRevision = FullRevision.parseRevision((String)value);
        }
        catch (FileNotFoundException ignore) {
            Closeables.closeQuietly(reader);
            return null;
            catch (IOException ignore2) {
                Closeables.closeQuietly(reader);
                return null;
                catch (NumberFormatException numberFormatException) {
                    Closeables.closeQuietly(reader);
                    return null;
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(reader);
                        throw throwable;
                    }
                }
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        return fullRevision;
    }

    @Override
    @NonNull
    public File getZipAlign() {
        if (this.mZipAlign == null) {
            this.mZipAlign = new File(this.getToolsFolder(), SdkConstants.FN_ZIPALIGN);
        }
        return this.mZipAlign;
    }

    @Override
    @NonNull
    public File getAdb() {
        if (this.mAdb == null) {
            this.mAdb = new File(this.getPlatformToolsFolder(), SdkConstants.FN_ADB);
        }
        return this.mAdb;
    }

    @Override
    @NonNull
    public List<File> getRepositories() {
        File googleRepo;
        ArrayList repositories = Lists.newArrayList();
        File androidRepo = new File(this.mSdkLocation + "/extras/android/m2repository");
        if (androidRepo.isDirectory()) {
            repositories.add(androidRepo);
        }
        if ((googleRepo = new File(this.mSdkLocation + "/extras/google/m2repository")).isDirectory()) {
            repositories.add(googleRepo);
        }
        return repositories;
    }

    @NonNull
    private File getPlatformToolsFolder() {
        if (this.mPlatformTools == null) {
            this.mPlatformTools = new File(this.mSdkLocation, "platform-tools");
            if (!this.mPlatformTools.isDirectory()) {
                throw new IllegalStateException("Platform-tools folder missing: " + this.mPlatformTools.getAbsolutePath());
            }
        }
        return this.mPlatformTools;
    }

    @NonNull
    private File getToolsFolder() {
        if (this.mTools == null) {
            this.mTools = new File(this.mSdkLocation, "tools");
            if (!this.mTools.isDirectory()) {
                throw new IllegalStateException("Platform-tools folder missing: " + this.mTools.getAbsolutePath());
            }
        }
        return this.mTools;
    }
}

