/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class DigestUtil {
    private static String encodingCharset = "UTF-8";

    public static String hmacSign(String aValue, String aKey) {
        byte[] value;
        byte[] keyb;
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        try {
            keyb = aKey.getBytes(encodingCharset);
            value = aValue.getBytes(encodingCharset);
        }
        catch (UnsupportedEncodingException e) {
            keyb = aKey.getBytes();
            value = aValue.getBytes();
        }
        Arrays.fill(k_ipad, keyb.length, 64, (byte)54);
        Arrays.fill(k_opad, keyb.length, 64, (byte)92);
        int i = 0;
        while (i < keyb.length) {
            k_ipad[i] = (byte)(keyb[i] ^ 0x36);
            k_opad[i] = (byte)(keyb[i] ^ 0x5C);
            ++i;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(k_ipad);
        md.update(value);
        byte[] dg = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(dg, 0, 16);
        dg = md.digest();
        return DigestUtil.toHex(dg);
    }

    public static String toHex(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer(input.length * 2);
        int i = 0;
        while (i < input.length) {
            int current = input[i] & 0xFF;
            if (current < 16) {
                output.append("0");
            }
            output.append(Integer.toString(current, 16));
            ++i;
        }
        return output.toString();
    }

    public static String getHmac(String[] args, String key) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            str.append(args[i]);
            ++i;
        }
        return DigestUtil.hmacSign(str.toString(), key);
    }

    public static String digest(String aValue) {
        byte[] value;
        aValue = aValue.trim();
        try {
            value = aValue.getBytes(encodingCharset);
        }
        catch (UnsupportedEncodingException e) {
            value = aValue.getBytes();
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return DigestUtil.toHex(md.digest(value));
    }
}

