/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepopulateConversionErrorFieldValidatorSupport
extends FieldValidatorSupport {
    private static final Log _log = LogFactory.getLog((Class)RepopulateConversionErrorFieldValidatorSupport.class);
    private String repopulateFieldAsString = "false";
    private boolean repopulateFieldAsBoolean = false;

    public String getRepopulateField() {
        return this.repopulateFieldAsString;
    }

    public void setRepopulateField(String repopulateField) {
        this.repopulateFieldAsString = repopulateField == null ? repopulateField : repopulateField.trim();
        this.repopulateFieldAsBoolean = "true".equalsIgnoreCase(this.repopulateFieldAsString);
    }

    public void validate(Object object) throws ValidationException {
        this.doValidate(object);
        if (this.repopulateFieldAsBoolean) {
            this.repopulateField(object);
        }
    }

    public void repopulateField(Object object) throws ValidationException {
        ActionInvocation invocation = ActionContext.getContext().getActionInvocation();
        Map conversionErrors = ActionContext.getContext().getConversionErrors();
        String fieldName = this.getFieldName();
        String fullFieldName = this.getValidatorContext().getFullFieldName(fieldName);
        Object value = conversionErrors.get(fullFieldName);
        final LinkedHashMap<String, String> fakeParams = new LinkedHashMap<String, String>();
        boolean doExprOverride = false;
        if (value instanceof String[]) {
            String[] tmpValue = (String[])value;
            if (tmpValue != null && tmpValue.length > 0) {
                doExprOverride = true;
                fakeParams.put(fieldName, "'" + tmpValue[0] + "'");
            } else {
                _log.warn((Object)("value is an empty array of String or with first element in it as null [" + value + "], will not repopulate conversion error "));
            }
        } else if (value instanceof String) {
            String tmpValue = (String)value;
            doExprOverride = true;
            fakeParams.put(fieldName, "'" + tmpValue + "'");
        } else {
            _log.warn((Object)("conversion error value is not a String or array of String but instead is [" + value + "], will not repopulate conversion error"));
        }
        if (doExprOverride) {
            invocation.addPreResultListener(new PreResultListener(){

                public void beforeResult(ActionInvocation invocation, String resultCode) {
                    OgnlValueStack stack = ActionContext.getContext().getValueStack();
                    stack.setExprOverrides(fakeParams);
                }
            });
        }
    }

    protected abstract void doValidate(Object var1) throws ValidationException;
}

