/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.ObjectTypeDeterminer;
import com.opensymphony.xwork.util.OgnlContextState;
import com.opensymphony.xwork.util.SurrugateList;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.SetPropertyAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkCollectionPropertyAccessor
extends SetPropertyAccessor {
    private static final Log LOG = LogFactory.getLog((Class)XWorkCollectionPropertyAccessor.class);
    private static final String CONTEXT_COLLECTION_MAP = "xworkCollectionPropertyAccessorContextSetMap";
    public static final String KEY_PROPERTY_FOR_CREATION = "makeNew";
    private ObjectPropertyAccessor _accessor = new ObjectPropertyAccessor();

    public Object getProperty(Map context, Object target, Object key) throws OgnlException {
        LOG.debug((Object)"Entering getProperty()");
        if (!OgnlContextState.isGettingByKeyProperty(context) && !key.equals(KEY_PROPERTY_FOR_CREATION)) {
            return super.getProperty(context, target, key);
        }
        OgnlContextState.setGettingByKeyProperty(context, false);
        Collection c = (Collection)target;
        Class lastBeanClass = OgnlContextState.getLastBeanClassAccessed(context);
        String lastPropertyClass = OgnlContextState.getLastBeanPropertyAccessed(context);
        if (lastBeanClass == null || lastPropertyClass == null) {
            OgnlContextState.updateCurrentPropertyPath(context, key);
            return super.getProperty(context, target, key);
        }
        ObjectTypeDeterminer objTypeDeterminer = XWorkConverter.getInstance().getObjectTypeDeterminer();
        String keyProperty = objTypeDeterminer.getKeyProperty(lastBeanClass, lastPropertyClass);
        Class<?> collClass = XWorkConverter.getInstance().getObjectTypeDeterminer().getElementClass(lastBeanClass, lastPropertyClass, key);
        Class<?> keyType = null;
        Class<?> toGetTypeFrom = collClass != null ? collClass : c.iterator().next().getClass();
        try {
            keyType = OgnlRuntime.getPropertyDescriptor(toGetTypeFrom, (String)keyProperty).getPropertyType();
        }
        catch (Exception exc) {
            throw new OgnlException("Error getting property descriptor: " + exc.getMessage());
        }
        if (OgnlContextState.isCreatingNullObjects(context)) {
            Map collMap = this.getSetMap(context, c, keyProperty, collClass);
            if (key.toString().equals(KEY_PROPERTY_FOR_CREATION)) {
                return collMap.get(null);
            }
            Object realKey = XWorkConverter.getInstance().convertValue(context, key, keyType);
            Object value = collMap.get(realKey);
            if (value == null && OgnlContextState.isCreatingNullObjects(context) && objTypeDeterminer.shouldCreateIfNew(lastBeanClass, lastPropertyClass, c, keyProperty, false)) {
                try {
                    value = ObjectFactory.getObjectFactory().buildBean(collClass, context);
                    this._accessor.setProperty(context, value, (Object)keyProperty, realKey);
                    c.add(value);
                    collMap.put(realKey, value);
                }
                catch (Exception exc) {
                    throw new OgnlException("Error adding new element to collection", (Throwable)exc);
                }
            }
            return value;
        }
        if (key.toString().equals(KEY_PROPERTY_FOR_CREATION)) {
            return null;
        }
        Object realKey = XWorkConverter.getInstance().convertValue(context, key, keyType);
        return this.getPropertyThroughIteration(context, c, keyProperty, realKey);
    }

    private Map getSetMap(Map context, Collection collection, String property, Class valueClass) throws OgnlException {
        LOG.debug((Object)"getting set Map");
        String path = OgnlContextState.getCurrentPropertyPath(context);
        HashMap<Object, SurrugateList> map = OgnlContextState.getSetMap(context, path);
        if (map == null) {
            LOG.debug((Object)"creating set Map");
            map = new HashMap<Object, SurrugateList>();
            map.put(null, new SurrugateList(collection));
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                Object currTest = i.next();
                Object currKey = this._accessor.getProperty(context, currTest, (Object)property);
                if (currKey == null) continue;
                map.put(currKey, (SurrugateList)currTest);
            }
            OgnlContextState.setSetMap(context, map, path);
        }
        return map;
    }

    public Object getPropertyThroughIteration(Map context, Collection collection, String property, Object key) throws OgnlException {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object currTest = i.next();
            if (!this._accessor.getProperty(context, currTest, (Object)property).equals(key)) continue;
            return currTest;
        }
        return null;
    }

    public void setProperty(Map arg0, Object arg1, Object arg2, Object arg3) throws OgnlException {
        super.setProperty(arg0, arg1, arg2, arg3);
    }
}

