/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class StreamsTest
extends TestCase {
    private static final String EXCEPTION_MSG = "pretend";

    public void testStreamsCopyErrorSilent() throws Exception {
        ThrowingInputStream from = new ThrowingInputStream();
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        boolean isBuffered = false;
        boolean terminateOnFalure = true;
        new Streams().copy(from, to, isBuffered, terminateOnFalure);
        StreamsTest.assertEquals((String)from.data(), (String)new String(to.toByteArray()));
    }

    public void testStreamsCopyError() throws Exception {
        this.checkCopyError(true);
        this.checkCopyError(false);
    }

    private void checkCopyError(boolean isIOException) throws Exception {
        ThrowingInputStream from = new ThrowingInputStream();
        from.ioexception = isIOException;
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        boolean isBuffered = false;
        boolean terminateOnFalure = false;
        Exception expected = null;
        try {
            new Streams().copy(from, to, isBuffered, terminateOnFalure);
        }
        catch (Exception e) {
            expected = e;
        }
        StreamsTest.assertNotNull((Object)expected);
        StreamsTest.assertEquals((String)EXCEPTION_MSG, (String)expected.getMessage());
        StreamsTest.assertEquals((String)from.data(), (String)new String(to.toByteArray()));
    }

    private static class ThrowingInputStream
    extends InputStream {
        private char c = (char)48;
        boolean ioexception;

        private ThrowingInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.c < '5') {
                char c = this.c;
                this.c = (char)(c + '\u0001');
                return c;
            }
            if (this.ioexception) {
                throw new IOException(StreamsTest.EXCEPTION_MSG);
            }
            throw new RuntimeException(StreamsTest.EXCEPTION_MSG);
        }

        @Override
        public void reset() {
            this.c = (char)48;
        }

        String data() {
            return "01234";
        }
    }
}

