/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class SQLRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String sql;
    private Object[] params;

    public SQLRuntimeException(SQLException cause) {
        this(cause, null, null);
    }

    public SQLRuntimeException(Throwable cause, String sql) {
        this(cause, sql, null);
    }

    public SQLRuntimeException(Throwable cause, String sql, Object[] params) {
        super(cause);
        this.sql = sql;
        this.params = params;
    }

    public SQLRuntimeException(String msg, String sql, Object[] params) {
        super(msg);
        this.sql = sql;
        this.params = params;
    }

    public SQLRuntimeException(String msg, Throwable cause, String sql, Object[] params) {
        super(msg, cause);
        this.sql = sql;
        this.params = params;
    }

    public int getErrorCode() {
        for (Throwable t = this; t != null; t = t.getCause()) {
            if (!(t instanceof SQLException)) continue;
            return ((SQLException)t).getErrorCode();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps);
            this.printState(pw);
            pw.flush();
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            this.printState(pw);
            super.printStackTrace(pw);
        }
    }

    private void printState(PrintWriter p) {
        p.println("SQL: " + this.sql);
        if (this.params != null) {
            if (this.params instanceof Object[][]) {
                for (int i = 0; i < this.params.length; ++i) {
                    this.dumpParams(p, ((Object[][])this.params)[i]);
                }
            } else {
                this.dumpParams(p, this.params);
            }
        }
        p.println("ErrorCode: " + this.getErrorCode());
    }

    private void dumpParams(PrintWriter p, Object[] paramList) {
        p.print("PARAMS: ");
        for (int i = 0; i < paramList.length; ++i) {
            Object param = paramList[i];
            String type = param == null ? "no type" : this.shortClassName(param.getClass());
            p.print(" (" + type + "): '" + param + "' ");
        }
        p.println();
    }

    private String shortClassName(Class aClass) {
        String name = aClass.getName();
        int lastDot = name.lastIndexOf(46);
        return name.substring(lastDot + 1);
    }
}

