/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public interface RuntimeI {
    public void addShutdownHook(Thread var1);

    public int availableProcessors();

    public Process exec(String var1, String[] var2, File var3);

    public Process exec(String var1, String[] var2);

    public Process exec(String var1);

    public Process exec(String[] var1, String[] var2, File var3);

    public Process exec(String[] var1, String[] var2);

    public Process exec(String[] var1);

    public void exit(int var1);

    public long freeMemory();

    public void gc();

    public InputStream getLocalizedInputStream(InputStream var1);

    public OutputStream getLocalizedOutputStream(OutputStream var1);

    public void halt(int var1);

    public void load(String var1);

    public void loadLibrary(String var1);

    public long maxMemory();

    public boolean removeShutdownHook(Thread var1);

    public void runFinalization();

    public long totalMemory();

    public void traceInstructions(boolean var1);

    public void traceMethodCalls(boolean var1);

    public static class Stub
    implements RuntimeI {
        @Override
        public void addShutdownHook(Thread hook) {
            throw new NotImplementedException(hook);
        }

        @Override
        public int availableProcessors() {
            throw new NotImplementedException();
        }

        @Override
        public Process exec(String command, String[] envp, File dir) {
            throw new NotImplementedException(command, envp, dir);
        }

        @Override
        public Process exec(String cmd, String[] envp) {
            throw new NotImplementedException((Object)cmd, envp);
        }

        @Override
        public Process exec(String command) {
            throw new NotImplementedException((Object)command);
        }

        @Override
        public Process exec(String[] cmdarray, String[] envp, File dir) {
            throw new NotImplementedException(cmdarray, envp, dir);
        }

        @Override
        public Process exec(String[] cmdarray, String[] envp) {
            throw new NotImplementedException(cmdarray, envp);
        }

        @Override
        public Process exec(String[] cmdarray) {
            throw new NotImplementedException(cmdarray);
        }

        @Override
        public void exit(int status) {
            throw new NotImplementedException(new Integer(status));
        }

        @Override
        public long freeMemory() {
            throw new NotImplementedException();
        }

        @Override
        public void gc() {
            throw new NotImplementedException();
        }

        @Override
        public InputStream getLocalizedInputStream(InputStream in) {
            throw new NotImplementedException(in);
        }

        @Override
        public OutputStream getLocalizedOutputStream(OutputStream out) {
            throw new NotImplementedException(out);
        }

        @Override
        public void halt(int status) {
            throw new NotImplementedException(new Integer(status));
        }

        @Override
        public void load(String filename) {
            throw new NotImplementedException((Object)filename);
        }

        @Override
        public void loadLibrary(String libname) {
            throw new NotImplementedException((Object)libname);
        }

        @Override
        public long maxMemory() {
            throw new NotImplementedException();
        }

        @Override
        public boolean removeShutdownHook(Thread hook) {
            throw new NotImplementedException(hook);
        }

        @Override
        public void runFinalization() {
            throw new NotImplementedException();
        }

        @Override
        public long totalMemory() {
            throw new NotImplementedException();
        }

        @Override
        public void traceInstructions(boolean on) {
            throw new NotImplementedException(new Boolean(on));
        }

        @Override
        public void traceMethodCalls(boolean on) {
            throw new NotImplementedException(new Boolean(on));
        }
    }

    public static final class Default
    extends Stub {
        Runtime runtime = Runtime.getRuntime();

        @Override
        public int availableProcessors() {
            return this.runtime.availableProcessors();
        }

        @Override
        public Process exec(final String[] cmdarray, final String[] envp, final File dir) {
            Exceptions.Block block = new Exceptions.Block(){

                @Override
                protected Object inner() throws Exception {
                    return Default.this.runtime.exec(cmdarray, envp, dir);
                }
            };
            return (Process)block.exec();
        }

        @Override
        public long freeMemory() {
            return this.runtime.freeMemory();
        }

        @Override
        public long maxMemory() {
            return this.runtime.maxMemory();
        }

        @Override
        public long totalMemory() {
            return this.runtime.totalMemory();
        }
    }
}

