/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.ProcessArrayCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public abstract class MulticastDelegate
implements Cloneable {
    protected Object[] targets = new Object[0];

    protected MulticastDelegate() {
    }

    public List getTargets() {
        return new ArrayList<Object>(Arrays.asList(this.targets));
    }

    public abstract MulticastDelegate add(Object var1);

    protected MulticastDelegate addHelper(Object target) {
        MulticastDelegate copy = this.newInstance();
        copy.targets = new Object[this.targets.length + 1];
        System.arraycopy(this.targets, 0, copy.targets, 0, this.targets.length);
        copy.targets[this.targets.length] = target;
        return copy;
    }

    public MulticastDelegate remove(Object target) {
        int i = this.targets.length - 1;
        while (i >= 0) {
            if (this.targets[i].equals(target)) {
                MulticastDelegate copy = this.newInstance();
                copy.targets = new Object[this.targets.length - 1];
                System.arraycopy(this.targets, 0, copy.targets, 0, i);
                System.arraycopy(this.targets, i + 1, copy.targets, i, this.targets.length - i - 1);
                return copy;
            }
            --i;
        }
        return this;
    }

    public abstract MulticastDelegate newInstance();

    public static MulticastDelegate create(Class iface) {
        Generator gen = new Generator();
        gen.setInterface(iface);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$reflect$MulticastDelegate == null ? (class$net$sf$cglib$reflect$MulticastDelegate = Generator.class$("net.sf.cglib.reflect.MulticastDelegate")) : class$net$sf$cglib$reflect$MulticastDelegate).getName());
        private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("net.sf.cglib.reflect.MulticastDelegate newInstance()");
        private static final Signature ADD_DELEGATE = TypeUtils.parseSignature("net.sf.cglib.reflect.MulticastDelegate add(Object)");
        private static final Signature ADD_HELPER = TypeUtils.parseSignature("net.sf.cglib.reflect.MulticastDelegate addHelper(Object)");
        private static final Type MULTICAST_DELEGATE = TypeUtils.parseType("net.sf.cglib.reflect.MulticastDelegate");
        private Class iface;
        static /* synthetic */ Class class$net$sf$cglib$reflect$MulticastDelegate;

        public Generator() {
            super(SOURCE);
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.iface.getClassLoader();
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        public MulticastDelegate create() {
            this.setNamePrefix((class$net$sf$cglib$reflect$MulticastDelegate == null ? (class$net$sf$cglib$reflect$MulticastDelegate = Generator.class$("net.sf.cglib.reflect.MulticastDelegate")) : class$net$sf$cglib$reflect$MulticastDelegate).getName());
            return (MulticastDelegate)super.create(this.iface.getName());
        }

        public void generateClass(ClassVisitor cv) {
            Method method = ReflectUtils.findInterfaceMethod(this.iface);
            ClassEmitter ce = new ClassEmitter(cv);
            ce.begin_class(1, this.getClassName(), MULTICAST_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            EmitUtils.null_constructor(ce);
            this.emitProxy(ce, method);
            CodeEmitter e = ce.begin_method(1, NEW_INSTANCE, null, null);
            e.new_instance_this();
            e.dup();
            e.invoke_constructor_this();
            e.return_value();
            e.end_method();
            e = ce.begin_method(1, ADD_DELEGATE, null, null);
            e.load_this();
            e.load_arg(0);
            e.checkcast(Type.getType(this.iface));
            e.invoke_virtual_this(ADD_HELPER);
            e.return_value();
            e.end_method();
            ce.end_class();
        }

        private void emitProxy(ClassEmitter ce, Method method) {
            CodeEmitter e = ce.begin_method(1, ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            Type returnType = e.getReturnType();
            boolean returns = returnType != Type.VOID_TYPE;
            Local result = null;
            if (returns) {
                result = e.make_local(returnType);
                e.zero_or_null(returnType);
                e.store_local(result);
            }
            e.load_this();
            e.super_getfield("targets", Constants.TYPE_OBJECT_ARRAY);
            Local result2 = result;
            EmitUtils.process_array(e, Constants.TYPE_OBJECT_ARRAY, new ProcessArrayCallback(this, e, method, returns, result2){
                private final /* synthetic */ CodeEmitter val$e;
                private final /* synthetic */ Method val$method;
                private final /* synthetic */ boolean val$returns;
                private final /* synthetic */ Local val$result2;
                private final /* synthetic */ Generator this$0;
                {
                    this.this$0 = this$0;
                    this.val$e = val$e;
                    this.val$method = val$method;
                    this.val$returns = val$returns;
                    this.val$result2 = val$result2;
                }

                public void processElement(Type type) {
                    this.val$e.checkcast(Type.getType(Generator.access$000(this.this$0)));
                    this.val$e.load_args();
                    this.val$e.invoke(this.val$method);
                    if (this.val$returns) {
                        this.val$e.store_local(this.val$result2);
                    }
                }
            });
            if (returns) {
                e.load_local(result);
            }
            e.return_value();
            e.end_method();
        }

        protected Object firstInstance(Class type) {
            return ((MulticastDelegate)ReflectUtils.newInstance(type)).newInstance();
        }

        protected Object nextInstance(Object instance) {
            return ((MulticastDelegate)instance).newInstance();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ Class access$000(Generator x0) {
            return x0.iface;
        }
    }
}

