/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.wizcrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.wiztools.wizcrypt.Callback;
import org.wiztools.wizcrypt.CipherKey;
import org.wiztools.wizcrypt.PasswordMismatchException;

public final class WizCrypt {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.wiztools.wizcrypt.wizcryptmsg");

    private WizCrypt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(InputStream is, OutputStream os, CipherKey ck, Callback cb, long size) throws IOException {
        CipherInputStream cis = null;
        try {
            if (cb != null) {
                cb.begin();
            }
            cis = new CipherInputStream(is, ck.cipher);
            os.write(ck.passKeyHash);
            int i = -1;
            byte[] buffer = new byte[65535];
            long readSize = 0L;
            while ((i = cis.read(buffer)) != -1) {
                os.write(buffer, 0, i);
                readSize += (long)i;
                if (cb == null) continue;
                if (size == -1L) {
                    cb.notifyProgress(readSize);
                    continue;
                }
                cb.notifyProgress(readSize * 100L / size);
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            try {
                if (cis != null) {
                    cis.close();
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            if (cb != null) {
                cb.end();
            }
        }
    }

    public static void encrypt(InputStream is, OutputStream os, CipherKey ck) throws IOException {
        WizCrypt.encrypt(is, os, ck, null, -1L);
    }

    public static void encrypt(InputStream is, OutputStream os, CipherKey ck, Callback cb) throws IOException {
        WizCrypt.encrypt(is, os, ck, cb, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(InputStream is, OutputStream os, CipherKey ck, Callback cb, long size) throws IOException, PasswordMismatchException {
        CipherOutputStream cos = null;
        try {
            if (cb != null) {
                cb.begin();
            }
            byte[] filePassKeyHash = new byte[16];
            is.read(filePassKeyHash, 0, 16);
            if (!Arrays.equals(ck.passKeyHash, filePassKeyHash)) {
                throw new PasswordMismatchException(rb.getString("err.pwd.not.match"));
            }
            cos = new CipherOutputStream(os, ck.cipher);
            int i = -1;
            byte[] buffer = new byte[65535];
            long readSize = 0L;
            while ((i = is.read(buffer)) != -1) {
                cos.write(buffer, 0, i);
                readSize += (long)i;
                if (cb == null) continue;
                if (size == -1L) {
                    cb.notifyProgress(readSize);
                    continue;
                }
                cb.notifyProgress(readSize * 100L / size);
            }
        }
        finally {
            try {
                if (cos != null) {
                    cos.close();
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            if (cb != null) {
                cb.end();
            }
        }
    }

    public static void decrypt(InputStream is, OutputStream os, CipherKey ck) throws IOException, PasswordMismatchException {
        WizCrypt.decrypt(is, os, ck, null, -1L);
    }

    public static void decrypt(InputStream is, OutputStream os, CipherKey ck, Callback cb) throws IOException, PasswordMismatchException {
        WizCrypt.decrypt(is, os, ck, cb, -1L);
    }
}

