/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.wizcrypt;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.wiztools.wizcrypt.ConsoleNotAvailableException;
import org.wiztools.wizcrypt.Decrypt;
import org.wiztools.wizcrypt.DestinationFileExistsException;
import org.wiztools.wizcrypt.Encrypt;
import org.wiztools.wizcrypt.IProcess;
import org.wiztools.wizcrypt.PasswordMismatchException;

public class Main {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.wiztools.wizcrypt.wizcryptmsg");
    private static boolean IO_EXCEPTION = false;
    private static boolean INVALID_PWD = false;
    private static boolean PWD_MISMATCH = false;
    private static boolean SECURITY_EXCEPTION = false;
    private static boolean PARSE_EXCEPTION = false;
    private static boolean CONSOLE_NOT_AVBL_EXCEPTION = false;
    private static boolean DEST_FILE_EXISTS = false;
    private static final int C_IO_EXCEPTION = 1;
    private static final int C_INVALID_PWD = 2;
    private static final int C_PWD_MISMATCH = 3;
    private static final int C_CONSOLE_NOT_AVBL_EXCEPTION = 7;
    private static final int C_DEST_FILE_EXISTS = 8;
    private static final int C_MULTIPLE_EXCEPTION = 4;
    private static final int C_SECURITY_EXCEPTION = 5;
    private static final int C_PARSE_EXCEPTION = 6;

    private Options generateOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.password"));
        Option option = OptionBuilder.create((char)'p');
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"encrypt");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.encrypt"));
        option = OptionBuilder.create((char)'e');
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"decrypt");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.decrypt"));
        option = OptionBuilder.create((char)'d');
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.help"));
        option = OptionBuilder.create((char)'h');
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.version"));
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.verbose"));
        option = OptionBuilder.create((char)'v');
        options.addOption(option);
        OptionBuilder.withLongOpt((String)"force-overwrite");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)rb.getString("msg.force.overwrite"));
        option = OptionBuilder.create((char)'f');
        options.addOption(option);
        return options;
    }

    private void printCommandLineHelp(Options options) {
        HelpFormatter hf = new HelpFormatter();
        String cmdLine = rb.getString("display.cmdline");
        String descriptor = rb.getString("display.detail");
        String moreHelp = rb.getString("display.footer");
        hf.printHelp(cmdLine, descriptor, options, moreHelp);
    }

    private void printVersionInfo() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/wiztools/wizcrypt/VERSION");
        try {
            int i = -1;
            byte[] buffer = new byte[65535];
            while ((i = is.read(buffer)) != -1) {
                System.out.print(new String(buffer, 0, i));
            }
            is.close();
            System.out.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private char[] getConsolePassword(String msg) throws PasswordMismatchException, ConsoleNotAvailableException {
        Console cons = System.console();
        if (cons == null) {
            throw new ConsoleNotAvailableException();
        }
        char[] passwd = cons.readPassword("%s ", msg);
        if (passwd == null) {
            throw new PasswordMismatchException(rb.getString("err.no.pwd"));
        }
        return passwd;
    }

    private char[] getConsolePassword() throws PasswordMismatchException, ConsoleNotAvailableException {
        return this.getConsolePassword(rb.getString("msg.interactive.password"));
    }

    private char[] getConsolePasswordVerify() throws PasswordMismatchException, ConsoleNotAvailableException {
        char[] passwd_retype;
        char[] passwd = this.getConsolePassword(rb.getString("msg.interactive.password"));
        if (!Arrays.equals(passwd, passwd_retype = this.getConsolePassword(rb.getString("msg.interactive.password.again")))) {
            throw new PasswordMismatchException(rb.getString("err.interactive.pwd.not.match"));
        }
        return passwd;
    }

    public Main(String[] arg) {
        Options options = this.generateOptions();
        try {
            String pwdStr;
            boolean encrypt = false;
            boolean decrypt = false;
            boolean forceOverwrite = false;
            boolean verbose = false;
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, arg);
            if (cmd.hasOption('h')) {
                this.printCommandLineHelp(options);
                return;
            }
            if (cmd.hasOption("version")) {
                this.printVersionInfo();
                return;
            }
            String[] args = cmd.getArgs();
            if (args == null || args.length == 0) {
                throw new ParseException(rb.getString("err.no.file"));
            }
            if (cmd.hasOption('v')) {
                verbose = true;
            }
            if (cmd.hasOption('f')) {
                forceOverwrite = true;
            }
            if (cmd.hasOption('e')) {
                encrypt = true;
            }
            if (cmd.hasOption('d')) {
                decrypt = true;
            }
            if (encrypt && decrypt) {
                throw new ParseException(rb.getString("err.both.selected"));
            }
            if (!encrypt && !decrypt) {
                throw new ParseException(rb.getString("err.none.selected"));
            }
            char[] pwd = null;
            pwd = cmd.hasOption('p') ? ((pwdStr = cmd.getOptionValue('p')) == null ? (encrypt ? this.getConsolePasswordVerify() : this.getConsolePassword()) : pwdStr.toCharArray()) : (encrypt ? this.getConsolePasswordVerify() : this.getConsolePassword());
            IProcess iprocess = null;
            if (encrypt) {
                iprocess = new Encrypt();
            } else if (decrypt) {
                iprocess = new Decrypt();
            }
            iprocess.init(new String(pwd));
            for (int i = 0; i < args.length; ++i) {
                File f = new File(args[i]);
                try {
                    iprocess.process(f, forceOverwrite);
                    if (!verbose) continue;
                    System.out.println(rb.getString("msg.verbose.success") + f.getCanonicalPath() + ".wiz");
                    continue;
                }
                catch (DestinationFileExistsException dfe) {
                    DEST_FILE_EXISTS = true;
                    System.err.println(dfe.getMessage());
                    continue;
                }
                catch (PasswordMismatchException pme) {
                    PWD_MISMATCH = true;
                    System.err.println(pme.getMessage());
                    continue;
                }
                catch (IOException ioe) {
                    IO_EXCEPTION = true;
                    System.err.println(ioe.getMessage());
                }
            }
        }
        catch (ParseException pe) {
            PARSE_EXCEPTION = true;
            System.err.println(pe.getMessage());
            this.printCommandLineHelp(options);
        }
        catch (ConsoleNotAvailableException cna) {
            CONSOLE_NOT_AVBL_EXCEPTION = true;
            System.err.println(rb.getString("err.console.not.avbl"));
        }
        catch (PasswordMismatchException pme) {
            INVALID_PWD = true;
            System.err.println(pme.getMessage());
        }
        catch (InvalidKeyException ike) {
            INVALID_PWD = true;
            System.err.println(rb.getString("err.invalid.pwd"));
        }
        catch (GeneralSecurityException gse) {
            SECURITY_EXCEPTION = true;
            System.err.println(gse.getMessage());
        }
    }

    public static void main(String[] arg) {
        new Main(arg);
        int exitVal = 0;
        if (PARSE_EXCEPTION) {
            exitVal = 6;
        } else if (CONSOLE_NOT_AVBL_EXCEPTION) {
            exitVal = 7;
        } else if (INVALID_PWD) {
            exitVal = 2;
        } else if (SECURITY_EXCEPTION) {
            exitVal = 5;
        } else {
            int count = 0;
            if (DEST_FILE_EXISTS) {
                exitVal = 8;
                ++count;
            }
            if (IO_EXCEPTION) {
                exitVal = 1;
                ++count;
            }
            if (PWD_MISMATCH) {
                exitVal = 3;
                ++count;
            }
            if (count > 1) {
                exitVal = 4;
            }
        }
        System.exit(exitVal);
    }
}

