/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.wizcrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import javax.crypto.NoSuchPaddingException;
import org.wiztools.wizcrypt.CipherKey;
import org.wiztools.wizcrypt.CipherKeyGen;
import org.wiztools.wizcrypt.DestinationFileExistsException;
import org.wiztools.wizcrypt.IProcess;
import org.wiztools.wizcrypt.WizCrypt;

public class Encrypt
implements IProcess {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.wiztools.wizcrypt.wizcryptmsg");
    private CipherKey ce;

    @Override
    public void init(String keyStr) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        this.ce = CipherKeyGen.getCipherKeyForEncrypt(keyStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(File file, boolean forceOverwrite) throws FileNotFoundException, DestinationFileExistsException, IOException {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        boolean canDelete = false;
        try {
            File outFile = new File(file.getCanonicalPath() + ".wiz");
            if (!forceOverwrite && outFile.exists()) {
                throw new DestinationFileExistsException(rb.getString("err.destination.file.exists") + outFile.getCanonicalPath());
            }
            fis = new FileInputStream(file);
            fos = new FileOutputStream(outFile);
            WizCrypt.encrypt(fis, fos, this.ce);
            canDelete = true;
        }
        finally {
            if (canDelete) {
                file.delete();
            }
        }
    }
}

