/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.wizcrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import javax.crypto.NoSuchPaddingException;
import org.wiztools.wizcrypt.CipherKey;
import org.wiztools.wizcrypt.CipherKeyGen;
import org.wiztools.wizcrypt.DestinationFileExistsException;
import org.wiztools.wizcrypt.IProcess;
import org.wiztools.wizcrypt.PasswordMismatchException;
import org.wiztools.wizcrypt.WizCrypt;

public class Decrypt
implements IProcess {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.wiztools.wizcrypt.wizcryptmsg");
    private CipherKey ce;

    @Override
    public void init(String keyStr) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        this.ce = CipherKeyGen.getCipherKeyForDecrypt(keyStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(File file, boolean forceOverwrite) throws FileNotFoundException, DestinationFileExistsException, PasswordMismatchException, IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean canDelete = false;
        try {
            String path = file.getCanonicalPath();
            if (!path.endsWith(".wiz")) {
                throw new FileNotFoundException(rb.getString("err.file.not.end.wiz") + path);
            }
            String newPath = path.replaceFirst(".wiz$", "");
            File outFile = new File(newPath);
            if (!forceOverwrite && outFile.exists()) {
                throw new DestinationFileExistsException(rb.getString("err.destination.file.exists") + outFile.getCanonicalPath());
            }
            fis = new FileInputStream(file);
            fos = new FileOutputStream(outFile);
            WizCrypt.decrypt(fis, fos, this.ce);
            canDelete = true;
        }
        finally {
            if (canDelete) {
                file.delete();
            }
        }
    }
}

