/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.wizcrypt;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.wiztools.wizcrypt.CipherKey;

public final class CipherKeyGen {
    private static final String ALGO = ResourceBundle.getBundle("org.wiztools.wizcrypt.wizcrypt").getString("algorithm");

    private CipherKeyGen() {
    }

    private static byte[] passHash(String password) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(password.getBytes());
        byte[] raw = md.digest();
        return raw;
    }

    private static CipherKey getCipherKey(String keyStr, int mode) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        byte[] passKeyHash = null;
        Cipher cipher = null;
        SecretKeySpec key = new SecretKeySpec(keyStr.getBytes(), ALGO);
        cipher = Cipher.getInstance(ALGO);
        cipher.init(mode, key);
        passKeyHash = CipherKeyGen.passHash(keyStr);
        CipherKey ck = new CipherKey(cipher, passKeyHash);
        return ck;
    }

    public static CipherKey getCipherKeyForEncrypt(String keyStr) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        return CipherKeyGen.getCipherKey(keyStr, 1);
    }

    public static CipherKey getCipherKeyForDecrypt(String keyStr) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        return CipherKeyGen.getCipherKey(keyStr, 2);
    }
}

