/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.webbitserver.EventSourceHandler;
import org.webbitserver.HttpHandler;
import org.webbitserver.WebServer;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.WebbitException;
import org.webbitserver.handler.DateHeaderHandler;
import org.webbitserver.handler.HttpToEventSourceHandler;
import org.webbitserver.handler.HttpToWebSocketHandler;
import org.webbitserver.handler.PathMatchHandler;
import org.webbitserver.handler.ServerHeaderHandler;
import org.webbitserver.handler.exceptions.PrintStackTraceExceptionHandler;
import org.webbitserver.handler.exceptions.SilentExceptionHandler;
import org.webbitserver.helpers.NamingThreadFactory;
import org.webbitserver.helpers.SslFactory;
import org.webbitserver.netty.ConnectionTrackingHandler;
import org.webbitserver.netty.FlashPolicyFileDecoder;
import org.webbitserver.netty.NettyHttpChannelHandler;
import org.webbitserver.netty.StaleConnectionTrackingHandler;

public class NettyWebServer
implements WebServer {
    private static final long DEFAULT_STALE_CONNECTION_TIMEOUT = 5000L;
    private final SocketAddress socketAddress;
    private final URI publicUri;
    private final List<HttpHandler> handlers = new ArrayList<HttpHandler>();
    private final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private final Executor executor;
    private ServerBootstrap bootstrap;
    private Channel channel;
    private SSLContext sslContext;
    protected long nextId = 1L;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Thread.UncaughtExceptionHandler ioExceptionHandler;
    private ConnectionTrackingHandler connectionTrackingHandler;
    private StaleConnectionTrackingHandler staleConnectionTrackingHandler;
    private long staleConnectionTimeout = 5000L;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private int maxContentLength = 65536;

    public NettyWebServer(int port) {
        this(Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("WEBBIT-HANDLER-THREAD")), port);
    }

    private NettyWebServer(ExecutorService executorService, int port) {
        this((Executor)executorService, port);
        this.executorServices.add(executorService);
    }

    public NettyWebServer(Executor executor, int port) {
        this(executor, new InetSocketAddress(port), NettyWebServer.localUri(port));
    }

    public NettyWebServer(Executor executor, SocketAddress socketAddress, URI publicUri) {
        this.executor = executor;
        this.socketAddress = socketAddress;
        this.publicUri = publicUri;
        this.uncaughtExceptionHandler(new PrintStackTraceExceptionHandler());
        this.connectionExceptionHandler(new SilentExceptionHandler());
        this.setupDefaultHandlers();
    }

    protected void setupDefaultHandlers() {
        this.add(new ServerHeaderHandler("Webbit"));
        this.add(new DateHeaderHandler());
    }

    @Override
    public NettyWebServer setupSsl(InputStream keyStore, String pass) throws WebbitException {
        return this.setupSsl(keyStore, pass, pass);
    }

    @Override
    public NettyWebServer setupSsl(InputStream keyStore, String storePass, String keyPass) throws WebbitException {
        this.sslContext = new SslFactory(keyStore, storePass).getServerContext(keyPass);
        return this;
    }

    @Override
    public URI getUri() {
        return this.publicUri;
    }

    @Override
    public int getPort() {
        if (this.publicUri.getPort() == -1) {
            return this.publicUri.getScheme().equalsIgnoreCase("https") ? 443 : 80;
        }
        return this.publicUri.getPort();
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public NettyWebServer staleConnectionTimeout(long millis) {
        this.staleConnectionTimeout = millis;
        return this;
    }

    @Override
    public NettyWebServer add(HttpHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public NettyWebServer add(String path, HttpHandler handler) {
        return this.add(new PathMatchHandler(path, handler));
    }

    @Override
    public NettyWebServer add(String path, WebSocketHandler handler) {
        return this.add(path, new HttpToWebSocketHandler(handler));
    }

    @Override
    public NettyWebServer add(String path, EventSourceHandler handler) {
        return this.add(path, new HttpToEventSourceHandler(handler));
    }

    @Override
    public Future<NettyWebServer> start() {
        FutureTask<NettyWebServer> future = new FutureTask<NettyWebServer>(new Callable<NettyWebServer>(){

            @Override
            public NettyWebServer call() throws Exception {
                if (NettyWebServer.this.isRunning()) {
                    throw new IllegalStateException("Server already started.");
                }
                NettyWebServer.this.bootstrap = new ServerBootstrap();
                NettyWebServer.this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                    public ChannelPipeline getPipeline() throws Exception {
                        long timestamp = NettyWebServer.this.timestamp();
                        Object id = NettyWebServer.this.nextId();
                        ChannelPipeline pipeline = Channels.pipeline();
                        if (NettyWebServer.this.sslContext != null) {
                            SSLEngine sslEngine = NettyWebServer.this.sslContext.createSSLEngine();
                            sslEngine.setUseClientMode(false);
                            SslHandler ssl = new SslHandler(sslEngine);
                            ssl.setCloseOnSSLException(true);
                            pipeline.addLast("ssl", (ChannelHandler)ssl);
                        }
                        pipeline.addLast("staleconnectiontracker", (ChannelHandler)NettyWebServer.this.staleConnectionTrackingHandler);
                        pipeline.addLast("connectiontracker", (ChannelHandler)NettyWebServer.this.connectionTrackingHandler);
                        pipeline.addLast("flashpolicydecoder", (ChannelHandler)new FlashPolicyFileDecoder(NettyWebServer.this.executor, NettyWebServer.this.exceptionHandler, NettyWebServer.this.ioExceptionHandler, NettyWebServer.this.getPort()));
                        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(NettyWebServer.this.maxInitialLineLength, NettyWebServer.this.maxHeaderSize, NettyWebServer.this.maxChunkSize));
                        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(NettyWebServer.this.maxContentLength));
                        pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
                        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                        pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
                        pipeline.addLast("handler", (ChannelHandler)new NettyHttpChannelHandler(NettyWebServer.this.executor, NettyWebServer.this.handlers, id, timestamp, NettyWebServer.this.exceptionHandler, NettyWebServer.this.ioExceptionHandler));
                        return pipeline;
                    }
                });
                NettyWebServer.this.staleConnectionTrackingHandler = new StaleConnectionTrackingHandler(NettyWebServer.this.staleConnectionTimeout, NettyWebServer.this.executor);
                ScheduledExecutorService staleCheckExecutor = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("WEBBIT-STALE-CONNECTION-CHECK-THREAD"));
                staleCheckExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        NettyWebServer.this.staleConnectionTrackingHandler.closeStaleConnections();
                    }
                }, NettyWebServer.this.staleConnectionTimeout / 2L, NettyWebServer.this.staleConnectionTimeout / 2L, TimeUnit.MILLISECONDS);
                NettyWebServer.this.executorServices.add(staleCheckExecutor);
                NettyWebServer.this.connectionTrackingHandler = new ConnectionTrackingHandler();
                ExecutorService bossExecutor = Executors.newSingleThreadExecutor(new NamingThreadFactory("WEBBIT-BOSS-THREAD"));
                NettyWebServer.this.executorServices.add(bossExecutor);
                ExecutorService workerExecutor = Executors.newSingleThreadExecutor(new NamingThreadFactory("WEBBIT-WORKER-THREAD"));
                NettyWebServer.this.executorServices.add(workerExecutor);
                NettyWebServer.this.bootstrap.setFactory((ChannelFactory)new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor, 1));
                NettyWebServer.this.channel = NettyWebServer.this.bootstrap.bind(NettyWebServer.this.socketAddress);
                return NettyWebServer.this;
            }
        });
        Thread thread = new Thread(future, "WEBBIT-STARTUP-THREAD");
        thread.start();
        return future;
    }

    public boolean isRunning() {
        return this.channel != null && this.channel.isBound();
    }

    @Override
    public Future<WebServer> stop() {
        FutureTask<WebServer> future = new FutureTask<WebServer>(new Callable<WebServer>(){

            @Override
            public WebServer call() throws Exception {
                if (NettyWebServer.this.channel != null) {
                    NettyWebServer.this.channel.close();
                }
                if (NettyWebServer.this.connectionTrackingHandler != null) {
                    NettyWebServer.this.connectionTrackingHandler.closeAllConnections();
                    NettyWebServer.this.connectionTrackingHandler = null;
                }
                if (NettyWebServer.this.bootstrap != null) {
                    NettyWebServer.this.bootstrap.releaseExternalResources();
                }
                for (ExecutorService executorService : NettyWebServer.this.executorServices) {
                    NettyWebServer.this.shutdownAndAwaitTermination(executorService);
                }
                NettyWebServer.this.bootstrap = null;
                if (NettyWebServer.this.channel != null) {
                    NettyWebServer.this.channel.getCloseFuture().await();
                }
                return NettyWebServer.this;
            }
        });
        Thread thread = new Thread(future, "WEBBIT-SHUTDOW-THREAD");
        thread.start();
        return future;
    }

    private void shutdownAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public NettyWebServer uncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public NettyWebServer connectionExceptionHandler(Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.ioExceptionHandler = ioExceptionHandler;
        return this;
    }

    public NettyWebServer maxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public NettyWebServer maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public NettyWebServer maxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public NettyWebServer maxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    private static URI localUri(int port) {
        try {
            return URI.create("http://" + InetAddress.getLocalHost().getHostName() + (port == 80 ? "" : ":" + port) + "/");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("can not create URI from localhost hostname - use constructor to pass an explicit URI", e);
        }
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    protected Object nextId() {
        return this.nextId++;
    }
}

