/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.transport.TServerSocket;
import tachyon.thrift.NetAddress;

public final class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static String sLocalHost;
    private static String sLocalIP;

    private NetworkUtils() {
    }

    public static String getLocalHostName(TachyonConf conf) {
        if (sLocalHost != null) {
            return sLocalHost;
        }
        int hostResolutionTimeout = conf.getInt("tachyon.host.resolution.timeout.ms", 5000);
        return NetworkUtils.getLocalHostName(hostResolutionTimeout);
    }

    public static String getLocalHostName(int timeout) {
        if (sLocalHost != null) {
            return sLocalHost;
        }
        try {
            sLocalHost = InetAddress.getByName(NetworkUtils.getLocalIpAddress(timeout)).getCanonicalHostName();
            return sLocalHost;
        }
        catch (UnknownHostException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getLocalIpAddress(TachyonConf conf) {
        if (sLocalIP != null) {
            return sLocalIP;
        }
        int hostResolutionTimeout = conf.getInt("tachyon.host.resolution.timeout.ms", 5000);
        return NetworkUtils.getLocalIpAddress(hostResolutionTimeout);
    }

    public static String getLocalIpAddress(int timeout) {
        if (sLocalIP != null) {
            return sLocalIP;
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            LOG.debug("address: {} isLoopbackAddress: {}, with host {} {}", new Object[]{address, address.isLoopbackAddress(), address.getHostAddress(), address.getHostName()});
            if (address.isLoopbackAddress() || !address.isReachable(timeout)) {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        address = addresses.nextElement();
                        if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address) || !address.isReachable(timeout)) continue;
                        sLocalIP = address.getHostAddress();
                        return sLocalIP;
                    }
                }
                LOG.warn("Your hostname, " + InetAddress.getLocalHost().getHostName() + " resolves to" + " a loopback/non-reachable address: " + address.getHostAddress() + ", but we couldn't find any external IP address!");
            }
            sLocalIP = address.getHostAddress();
            return sLocalIP;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static TachyonURI replaceHostName(TachyonURI path) throws UnknownHostException {
        if (path == null) {
            return null;
        }
        if (path.hasAuthority() && path.getPort() != -1) {
            String authority = NetworkUtils.resolveHostName(path.getHost());
            if (path.getPort() != -1) {
                authority = authority + ":" + path.getPort();
            }
            return new TachyonURI(path.getScheme(), authority, path.getPath());
        }
        return path;
    }

    public static String resolveHostName(String hostname) throws UnknownHostException {
        if (hostname == null || hostname.isEmpty()) {
            return null;
        }
        return InetAddress.getByName(hostname).getCanonicalHostName();
    }

    public static String getFqdnHost(InetSocketAddress addr) {
        return addr.getAddress().getCanonicalHostName();
    }

    public static String getFqdnHost(NetAddress addr) throws UnknownHostException {
        return NetworkUtils.resolveHostName(addr.getMHost());
    }

    public static int getPort(TServerSocket thriftSocket) {
        return NetworkUtils.getSocket(thriftSocket).getLocalPort();
    }

    public static ServerSocket getSocket(TServerSocket thriftSocket) {
        try {
            Field field = TServerSocket.class.getDeclaredField("serverSocket_");
            field.setAccessible(true);
            return (ServerSocket)field.get(thriftSocket);
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

