/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import tachyon.thrift.InvalidPathException;

public final class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"");

    public static void changeLocalFilePermission(String filePath, String perms) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add(perms);
        File file = new File(filePath);
        commands.add(file.getAbsolutePath());
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            process.waitFor();
            CommonUtils.redirectIO(process);
            if (process.exitValue() != 0) {
                throw new IOException("Can not change the file " + file.getAbsolutePath() + " 's permission to be " + perms);
            }
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
    }

    public static void createBlockPath(String path) throws IOException {
        File localFolder;
        try {
            localFolder = new File(CommonUtils.getParent(path));
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (!localFolder.exists()) {
            if (localFolder.mkdirs()) {
                CommonUtils.changeLocalFileToFullPermission(localFolder.getAbsolutePath());
                LOG.info("Folder {} was created!", (Object)localFolder);
            } else {
                throw new IOException("Failed to create folder " + localFolder);
            }
        }
    }

    private static void redirectIO(Process process) throws IOException {
        Closer closer = Closer.create();
        try {
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getInputStream())), (OutputStream)System.out);
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getErrorStream())), (OutputStream)System.err);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        CommonUtils.changeLocalFilePermission(filePath, "777");
    }

    public static void cleanDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.isDirect()) {
            Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
            cleaner.clean();
        }
    }

    public static String cleanPath(String path) throws InvalidPathException {
        CommonUtils.validatePath(path);
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)path));
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit() - buf.position());
        ret.put(buf.array(), buf.position(), buf.limit() - buf.position());
        ret.flip();
        return ret;
    }

    public static List<ByteBuffer> cloneByteBufferList(List<ByteBuffer> source) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(source.size());
        for (ByteBuffer b : source) {
            ret.add(CommonUtils.cloneByteBuffer(b));
        }
        return ret;
    }

    public static String concatPath(Object ... paths) throws IllegalArgumentException {
        String trimmedPath;
        String path;
        if (null == paths) {
            throw new IllegalArgumentException("Can not concatenate a null set of paths.");
        }
        ArrayList<String> trimmedPathList = new ArrayList<String>();
        if (paths.length > 0 && paths[0] != null && !paths[0].toString().isEmpty()) {
            path = paths[0].toString().trim();
            trimmedPath = CharMatcher.is((char)"/".charAt(0)).trimTrailingFrom((CharSequence)path);
            trimmedPathList.add(trimmedPath);
        }
        for (int k = 1; k < paths.length; ++k) {
            if (null == paths[k]) continue;
            path = paths[k].toString().trim();
            trimmedPath = CharMatcher.is((char)"/".charAt(0)).trimFrom((CharSequence)path);
            if (trimmedPath.isEmpty()) continue;
            trimmedPathList.add(trimmedPath);
        }
        if (trimmedPathList.size() == 1 && ((String)trimmedPathList.get(0)).isEmpty()) {
            return "/";
        }
        return Joiner.on((String)"/").join(trimmedPathList);
    }

    public static ByteBuffer generateNewByteBufferFromThriftRPCResults(ByteBuffer data) {
        ByteBuffer correctData = ByteBuffer.allocate(data.limit() - data.position());
        correctData.put(data);
        correctData.flip();
        return correctData;
    }

    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static String getParent(String path) throws InvalidPathException {
        String cleanedPath = CommonUtils.cleanPath(path);
        String name = FilenameUtils.getName((String)cleanedPath);
        String parent = cleanedPath.substring(0, cleanedPath.length() - name.length() - 1);
        if (parent.isEmpty()) {
            return "/";
        }
        return parent;
    }

    public static String[] getPathComponents(String path) throws InvalidPathException {
        if (CommonUtils.isRoot(path = CommonUtils.cleanPath(path))) {
            String[] ret = new String[]{""};
            return ret;
        }
        return path.split("/");
    }

    public static String getSizeFromBytes(long bytes) {
        double ret = bytes;
        if (ret <= 5120.0) {
            return String.format("%.2f B", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f KB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f MB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f GB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f TB", ret);
        }
        return String.format("%.2f PB", ret);
    }

    public static boolean isRoot(String path) throws InvalidPathException {
        return "/".equals(CommonUtils.cleanPath(path));
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T s : list) {
            sb.append(s).append(" ");
        }
        return sb.toString();
    }

    public static String parametersToString(Object ... objs) {
        StringBuilder sb = new StringBuilder("(");
        for (int k = 0; k < objs.length; ++k) {
            if (k != 0) {
                sb.append(", ");
            }
            sb.append(objs[k].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static InetSocketAddress parseInetSocketAddress(String address) throws IOException {
        if (address == null) {
            return null;
        }
        String[] strArr = address.split(":");
        if (strArr.length != 2) {
            throw new IOException("Invalid InetSocketAddress " + address);
        }
        return new InetSocketAddress(strArr[0], Integer.parseInt(strArr[1]));
    }

    public static long parseSpaceSize(String spaceSize) {
        int tIndex;
        double alpha = 1.0E-4;
        String ori = spaceSize;
        String end = "";
        for (tIndex = spaceSize.length() - 1; tIndex >= 0 && (spaceSize.charAt(tIndex) > '9' || spaceSize.charAt(tIndex) < '0'); --tIndex) {
            end = spaceSize.charAt(tIndex) + end;
        }
        spaceSize = spaceSize.substring(0, tIndex + 1);
        double ret = Double.parseDouble(spaceSize);
        if ((end = end.toLowerCase()).isEmpty() || end.equals("b")) {
            return (long)(ret + alpha);
        }
        if (end.equals("kb")) {
            return (long)(ret * 1024.0 + alpha);
        }
        if (end.equals("mb")) {
            return (long)(ret * 1048576.0 + alpha);
        }
        if (end.equals("gb")) {
            return (long)(ret * 1.073741824E9 + alpha);
        }
        if (end.equals("tb")) {
            return (long)(ret * 1.099511627776E12 + alpha);
        }
        if (end.equals("pb")) {
            BigDecimal pBDecimal = new BigDecimal(0x4000000000000L);
            return pBDecimal.multiply(BigDecimal.valueOf(ret)).longValue();
        }
        throw new IllegalArgumentException("Fail to parse " + ori + " to bytes");
    }

    public static void printByteBuffer(Logger LOG, ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < buf.limit() / 4; ++k) {
            sb.append(buf.getInt()).append(" ");
        }
        LOG.info(sb.toString());
    }

    public static void printTimeTakenMs(long startTimeMs, Logger logger, String message) {
        logger.info(message + " took " + (CommonUtils.getCurrentMs() - startTimeMs) + " ms.");
    }

    public static void printTimeTakenNs(long startTimeNs, Logger logger, String message) {
        logger.info(message + " took " + (System.nanoTime() - startTimeNs) + " ns.");
    }

    public static void putIntByteBuffer(ByteBuffer buf, int b) {
        buf.put((byte)(b & 0xFF));
    }

    public static void setLocalFileStickyBit(String file) {
        try {
            if (file.startsWith("/")) {
                Runtime.getRuntime().exec("chmod o+t " + file);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the file : " + file);
        }
    }

    public static void sleepMs(Logger logger, long timeMs) {
        CommonUtils.sleepMs(logger, timeMs, false);
    }

    public static void sleepMs(Logger logger, long timeMs, boolean shouldInterrupt) {
        block2: {
            try {
                Thread.sleep(timeMs);
            }
            catch (InterruptedException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (!shouldInterrupt) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path == null || path.isEmpty() || !path.startsWith("/") || path.contains(" ")) {
            throw new InvalidPathException("Path " + path + " is invalid.");
        }
    }

    public static <T> T createNewClassInstance(Class<T> cls, Class<?>[] ctorClassArgs, Object[] ctorArgs) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException {
        if (ctorClassArgs == null) {
            return cls.newInstance();
        }
        Constructor<T> ctor = cls.getConstructor(ctorClassArgs);
        return ctor.newInstance(ctorArgs);
    }
}

