/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol.databuffer;

import io.netty.channel.DefaultFileRegion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import tachyon.network.protocol.databuffer.DataBuffer;

public class DataFileChannel
extends DataBuffer {
    private final FileChannel mFileChannel;
    private final long mOffset;
    private final long mLength;

    public DataFileChannel(FileChannel fileChannel, long offset, long length) {
        this.mFileChannel = fileChannel;
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        return new DefaultFileRegion(this.mFileChannel, this.mOffset, this.mLength);
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate((int)this.mLength);
        try {
            this.mFileChannel.position(this.mOffset);
            int bytesRead = 0;
            for (long bytesRemaining = this.mLength; bytesRemaining > 0L && (bytesRead = this.mFileChannel.read(buffer)) >= 0; bytesRemaining -= (long)bytesRead) {
            }
        }
        catch (IOException ioe) {
            return null;
        }
        ByteBuffer readOnly = buffer.asReadOnlyBuffer();
        readOnly.position(0);
        return readOnly;
    }
}

