/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import tachyon.network.protocol.EncodedMessage;
import tachyon.network.protocol.RPCBlockRequest;
import tachyon.network.protocol.RPCBlockResponse;
import tachyon.network.protocol.RPCBlockWriteRequest;
import tachyon.network.protocol.RPCBlockWriteResponse;
import tachyon.network.protocol.RPCErrorResponse;
import tachyon.network.protocol.databuffer.DataBuffer;

public abstract class RPCMessage
implements EncodedMessage {
    public abstract Type getType();

    public void validate() {
    }

    public boolean hasPayload() {
        return this.getPayloadDataBuffer() != null;
    }

    public DataBuffer getPayloadDataBuffer() {
        return null;
    }

    public static ByteToMessageDecoder createFrameDecoder() {
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 8, -8, 8);
    }

    public static RPCMessage decodeMessage(Type type, ByteBuf in) {
        switch (type) {
            case RPC_ERROR_RESPONSE: {
                return RPCErrorResponse.decode(in);
            }
            case RPC_BLOCK_REQUEST: {
                return RPCBlockRequest.decode(in);
            }
            case RPC_BLOCK_RESPONSE: {
                return RPCBlockResponse.decode(in);
            }
            case RPC_BLOCK_WRITE_REQUEST: {
                return RPCBlockWriteRequest.decode(in);
            }
            case RPC_BLOCK_WRITE_RESPONSE: {
                return RPCBlockWriteResponse.decode(in);
            }
        }
        throw new IllegalArgumentException("Unknown RPCMessage type. type: " + type);
    }

    public static enum Type implements EncodedMessage
    {
        RPC_ERROR_RESPONSE(0),
        RPC_BLOCK_REQUEST(1),
        RPC_BLOCK_RESPONSE(2),
        RPC_BLOCK_WRITE_REQUEST(3),
        RPC_BLOCK_WRITE_RESPONSE(4);

        private final int mId;

        private Type(int id) {
            this.mId = id;
        }

        @Override
        public int getEncodedLength() {
            return 4;
        }

        @Override
        public void encode(ByteBuf out) {
            out.writeInt(this.mId);
        }

        public int getId() {
            return this.mId;
        }

        public static Type decode(ByteBuf in) {
            int id = in.readInt();
            switch (id) {
                case 0: {
                    return RPC_ERROR_RESPONSE;
                }
                case 1: {
                    return RPC_BLOCK_REQUEST;
                }
                case 2: {
                    return RPC_BLOCK_RESPONSE;
                }
                case 3: {
                    return RPC_BLOCK_WRITE_REQUEST;
                }
                case 4: {
                    return RPC_BLOCK_WRITE_RESPONSE;
                }
            }
            throw new IllegalArgumentException("Unknown RPCMessage type id. id: " + id);
        }
    }
}

