/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import tachyon.network.protocol.RPCBlockRequest;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;
import tachyon.network.protocol.databuffer.DataBuffer;
import tachyon.network.protocol.databuffer.DataByteBuffer;

public class RPCBlockResponse
extends RPCResponse {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final DataBuffer mData;
    private final RPCResponse.Status mStatus;

    public RPCBlockResponse(long blockId, long offset, long length, DataBuffer data, RPCResponse.Status status) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mData = data;
        this.mStatus = status;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_RESPONSE;
    }

    public static RPCBlockResponse createErrorResponse(RPCBlockRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCBlockResponse(request.getBlockId(), request.getOffset(), 0L, null, status);
    }

    public static RPCBlockResponse decode(ByteBuf in) {
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        DataByteBuffer data = null;
        if (length > 0L) {
            ByteBuffer buffer = ByteBuffer.allocate((int)length);
            in.readBytes(buffer);
            data = new DataByteBuffer(buffer, (int)length);
        }
        return new RPCBlockResponse(blockId, offset, length, data, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 26;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public String toString() {
        return "RPCBlockResponse(" + this.mBlockId + ", " + this.mOffset + ", " + this.mLength + ", " + (Object)((Object)this.mStatus) + ")";
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }
}

