/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.PrefixList;
import tachyon.TachyonURI;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.UfsUtils;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.hadoop.ConfUtils;
import tachyon.hadoop.HdfsFileInputStream;
import tachyon.hadoop.Utils;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

abstract class AbstractTFS
extends FileSystem {
    public static final String FIRST_COM_PATH = "tachyon_dep/";
    public static final String RECOMPUTE_PATH = "tachyon_recompute/";
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private String mUnderFSAddress;
    private URI mUri = null;
    private Path mWorkingDir = new Path("/");
    private TachyonFS mTFS = null;
    private String mTachyonHeader = null;
    private final TachyonConf mTachyonConf = new TachyonConf();

    AbstractTFS() {
    }

    public FSDataOutputStream append(Path cPath, int bufferSize, Progressable progress) throws IOException {
        LOG.info("append(" + cPath + ", " + bufferSize + ", " + progress + ")");
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        TachyonFile file = this.mTFS.getFile(fileId);
        if (file.length() > 0L) {
            LOG.warn("This maybe an error.");
        }
        WriteType type = this.getWriteType();
        return new FSDataOutputStream((OutputStream)file.getOutStream(type), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.mTFS != null) {
                this.mTFS.close();
            }
        }
    }

    public FSDataOutputStream create(Path cPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        int fileId;
        LOG.info("create(" + cPath + ", " + permission + ", " + overwrite + ", " + bufferSize + ", " + replication + ", " + blockSize + ", " + progress + ")");
        boolean asyncEnabled = this.mTachyonConf.getBoolean("tachyon.async.enabled", true);
        if (!asyncEnabled) {
            TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
            if (this.mTFS.exist(path)) {
                if (overwrite && !this.mTFS.getFileStatus((int)-1, (TachyonURI)path).isFolder) {
                    if (!this.mTFS.delete(path, false)) {
                        throw new IOException("Failed to delete existing data " + cPath);
                    }
                } else {
                    throw new IOException(cPath.toString() + " already exists. Directories cannot be " + "overwritten with create.");
                }
            }
            int fileId2 = this.mTFS.createFile(path, blockSize);
            TachyonFile file = this.mTFS.getFile(fileId2);
            file.setUFSConf(this.getConf());
            WriteType type = this.getWriteType();
            return new FSDataOutputStream((OutputStream)file.getOutStream(type), null);
        }
        if (cPath.toString().contains(FIRST_COM_PATH) && !cPath.toString().contains("SUCCESS")) {
            TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
            this.mTFS.createFile(path, blockSize);
            String depPath = path.getPath();
            depPath = depPath.substring(depPath.indexOf(FIRST_COM_PATH) + FIRST_COM_PATH.length());
            depPath = depPath.substring(0, depPath.indexOf("/"));
            int depId = Integer.parseInt(depPath);
            LOG.info("create(" + cPath + ") : " + depPath + " " + depId);
            depPath = path.getPath();
            depPath = depPath.substring(depPath.indexOf("part-") + 5);
            int index = Integer.parseInt(depPath);
            ClientDependencyInfo info = this.mTFS.getClientDependencyInfo(depId);
            int fileId3 = info.getChildren().get(index);
            LOG.info("create(" + cPath + ") : " + depPath + " " + index + " " + info + " " + fileId3);
            TachyonFile file = this.mTFS.getFile(fileId3);
            file.setUFSConf(this.getConf());
            return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.ASYNC_THROUGH), null);
        }
        if (cPath.toString().contains(RECOMPUTE_PATH) && !cPath.toString().contains("SUCCESS")) {
            TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
            this.mTFS.createFile(path, blockSize);
            String depPath = path.getPath();
            depPath = depPath.substring(depPath.indexOf(RECOMPUTE_PATH) + RECOMPUTE_PATH.length());
            depPath = depPath.substring(0, depPath.indexOf("/"));
            int depId = Integer.parseInt(depPath);
            LOG.info("create(" + cPath + ") : " + depPath + " " + depId);
            depPath = path.getPath();
            depPath = depPath.substring(depPath.indexOf("part-") + 5);
            int index = Integer.parseInt(depPath);
            ClientDependencyInfo info = this.mTFS.getClientDependencyInfo(depId);
            int fileId4 = info.getChildren().get(index);
            LOG.info("create(" + cPath + ") : " + depPath + " " + index + " " + info + " " + fileId4);
            TachyonFile file = this.mTFS.getFile(fileId4);
            file.setUFSConf(this.getConf());
            return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.ASYNC_THROUGH), null);
        }
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        WriteType type = this.getWriteType();
        if (this.mTFS.exist(path)) {
            fileId = this.mTFS.getFileId(path);
            type = WriteType.MUST_CACHE;
        } else {
            fileId = this.mTFS.createFile(path, blockSize);
        }
        TachyonFile file = this.mTFS.getFile(fileId);
        file.setUFSConf(this.getConf());
        return new FSDataOutputStream((OutputStream)file.getOutStream(type), null);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path cPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath.getParent()));
        this.fromHdfsToTachyon(path);
        if (!this.mTFS.exist(path)) {
            throw new FileNotFoundException("Parent directory does not exist!");
        }
        return this.create(cPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path cPath, boolean recursive) throws IOException {
        LOG.info("delete(" + cPath + ", " + recursive + ")");
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        this.fromHdfsToTachyon(path);
        if (!this.mTFS.exist(path)) {
            return false;
        }
        boolean rtn = this.mTFS.delete(path, recursive);
        if (this.mTFS.exist(path)) {
            throw new IOException("Failed to delete path " + path.toString());
        }
        return rtn;
    }

    private void fromHdfsToTachyon(TachyonURI path) throws IOException {
        if (!this.mTFS.exist(path)) {
            FileSystem fs;
            Path hdfsPath = Utils.getHDFSPath(path, this.mUnderFSAddress);
            Configuration conf = new Configuration(this.getConf());
            if (conf.get("fs.defaultFS") == null) {
                conf.set("fs.defaultFS", this.mUnderFSAddress);
            }
            if ((fs = hdfsPath.getFileSystem(conf)).exists(hdfsPath)) {
                TachyonURI ufsUri = new TachyonURI(this.mUnderFSAddress);
                TachyonURI ufsAddrPath = new TachyonURI(ufsUri.getScheme(), ufsUri.getAuthority(), path.getPath());
                UfsUtils.loadUnderFs(this.mTFS, path, ufsAddrPath, new PrefixList(null), this.mTachyonConf);
            }
        }
    }

    public long getDefaultBlockSize() {
        return this.mTachyonConf.getBytes("tachyon.user.default.block.size.byte", 0x20000000L);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(file.getPath()));
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        if (fileId == -1) {
            throw new FileNotFoundException("File does not exist: " + file.getPath());
        }
        ArrayList<BlockLocation> blockLocations = new ArrayList<BlockLocation>();
        List<ClientBlockInfo> blocks = this.mTFS.getFileBlocks(fileId);
        for (int k = 0; k < blocks.size(); ++k) {
            ClientBlockInfo info = blocks.get(k);
            long offset = info.getOffset();
            long end = offset + info.getLength();
            if ((offset < start || offset > start + len) && (end < start || end > start + len)) continue;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (NetAddress addr : info.getLocations()) {
                String name = addr.mHost + ":" + addr.mSecondaryPort;
                LOG.debug("getFileBlockLocations : adding name : '" + name + "");
                names.add(name);
                hosts.add(addr.mHost);
            }
            blockLocations.add(new BlockLocation(CommonUtils.toStringArray(names), CommonUtils.toStringArray(hosts), offset, info.getLength()));
        }
        BlockLocation[] ret = new BlockLocation[blockLocations.size()];
        blockLocations.toArray(ret);
        return ret;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        TachyonFile file;
        TachyonURI tPath = new TachyonURI(Utils.getPathWithoutScheme(path));
        Path hdfsPath = Utils.getHDFSPath(tPath, this.mUnderFSAddress);
        LOG.info("getFileStatus(" + path + "): HDFS Path: " + hdfsPath + " TPath: " + this.mTachyonHeader + tPath);
        if (this.useHdfs()) {
            this.fromHdfsToTachyon(tPath);
        }
        if ((file = this.mTFS.getFile(tPath)) == null) {
            LOG.info("File does not exist: " + path);
            throw new FileNotFoundException("File does not exist: " + path);
        }
        FileStatus ret = new FileStatus(file.length(), file.isDirectory(), file.getDiskReplication(), file.getBlockSizeByte(), file.getCreationTimeMs(), file.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + tPath));
        return ret;
    }

    public abstract String getScheme();

    public TachyonFS getTachyonFS() {
        return this.mTFS;
    }

    public URI getUri() {
        return this.mUri;
    }

    public Path getWorkingDirectory() {
        LOG.info("getWorkingDirectory: " + this.mWorkingDir);
        return this.mWorkingDir;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        LOG.info("initialize(" + uri + ", " + conf + "). Connecting to Tachyon: " + uri.toString());
        Utils.addS3Credentials(conf);
        this.setConf(conf);
        this.mTachyonHeader = this.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
        TachyonConf siteConf = ConfUtils.loadFromHadoopConfiguration(conf);
        if (siteConf != null) {
            this.mTachyonConf.merge(siteConf);
        }
        this.mTachyonConf.set("tachyon.master.hostname", uri.getHost());
        this.mTachyonConf.set("tachyon.master.port", Integer.toString(uri.getPort()));
        this.mTachyonConf.set("tachyon.usezookeeper", Boolean.toString(this.isZookeeperMode()));
        this.mTFS = TachyonFS.get(this.mTachyonConf);
        this.mUri = URI.create(this.mTachyonHeader);
        this.mUnderFSAddress = this.mTFS.getUfsAddress();
        LOG.info(this.mTachyonHeader + " " + this.mUri + " " + this.mUnderFSAddress);
    }

    protected abstract boolean isZookeeperMode();

    public FileStatus[] listStatus(Path path) throws IOException {
        TachyonURI tPath = new TachyonURI(Utils.getPathWithoutScheme(path));
        Path hdfsPath = Utils.getHDFSPath(tPath, this.mUnderFSAddress);
        LOG.info("listStatus(" + path + "): HDFS Path: " + hdfsPath);
        this.fromHdfsToTachyon(tPath);
        if (!this.mTFS.exist(tPath)) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        List<ClientFileInfo> files = this.mTFS.listStatus(tPath);
        FileStatus[] ret = new FileStatus[files.size()];
        for (int k = 0; k < files.size(); ++k) {
            ClientFileInfo info = files.get(k);
            ret[k] = new FileStatus(info.getLength(), info.isFolder, 3, info.getBlockSizeByte(), info.getCreationTimeMs(), info.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + info.getPath()));
        }
        return ret;
    }

    public boolean mkdirs(Path cPath, FsPermission permission) throws IOException {
        LOG.info("mkdirs(" + cPath + ", " + permission + ")");
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        return this.mTFS.mkdir(path);
    }

    public FSDataInputStream open(Path cPath, int bufferSize) throws IOException {
        LOG.info("open(" + cPath + ", " + bufferSize + ")");
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(this.mTFS, fileId, Utils.getHDFSPath(path, this.mUnderFSAddress), this.getConf(), bufferSize, this.mTachyonConf));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        LOG.info("rename(" + src + ", " + dst + ")");
        TachyonURI srcPath = new TachyonURI(Utils.getPathWithoutScheme(src));
        TachyonURI dstPath = new TachyonURI(Utils.getPathWithoutScheme(dst));
        ClientFileInfo info = this.mTFS.getFileStatus(-1, dstPath);
        if (info != null && info.isFolder) {
            dstPath = dstPath.join(srcPath.getName());
        }
        this.fromHdfsToTachyon(srcPath);
        try {
            return this.mTFS.rename(srcPath, dstPath);
        }
        catch (IOException ioe) {
            LOG.error("Failed to rename {} to {}", new Object[]{src, dst, ioe});
            return false;
        }
    }

    public void setWorkingDirectory(Path path) {
        LOG.info("setWorkingDirectory(" + path + ")");
        this.mWorkingDir = path.isAbsolute() ? path : new Path(this.mWorkingDir, path);
    }

    @Deprecated
    private boolean useHdfs() {
        return this.mUnderFSAddress != null && URI.create(this.mUnderFSAddress).getScheme() != null;
    }

    private WriteType getWriteType() {
        return this.mTachyonConf.getEnum("tachyon.user.file.writetype.default", WriteType.CACHE_THROUGH);
    }
}

