/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.RemoteBlockReader;
import tachyon.client.netty.ClientHandler;
import tachyon.client.netty.NettyClient;
import tachyon.client.netty.SingleResponseListener;
import tachyon.network.protocol.RPCBlockRequest;
import tachyon.network.protocol.RPCBlockResponse;
import tachyon.network.protocol.RPCErrorResponse;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;

public final class NettyRemoteBlockReader
implements RemoteBlockReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final Bootstrap mClientBootstrap;
    private final ClientHandler mHandler = new ClientHandler();

    public NettyRemoteBlockReader() {
        this.mClientBootstrap = NettyClient.createClientBootstrap(this.mHandler);
    }

    @Override
    public ByteBuffer readRemoteBlock(String host, int port, long blockId, long offset, long length) throws IOException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        try {
            ChannelFuture f = this.mClientBootstrap.connect((SocketAddress)address).sync();
            LOG.info("Connected to remote machine " + address);
            Channel channel = f.channel();
            SingleResponseListener listener = new SingleResponseListener();
            this.mHandler.addListener(listener);
            channel.writeAndFlush((Object)new RPCBlockRequest(blockId, offset, length));
            RPCResponse response = listener.get(NettyClient.TIMEOUT_MS, TimeUnit.MILLISECONDS);
            channel.close().sync();
            switch (response.getType()) {
                case RPC_BLOCK_RESPONSE: {
                    RPCBlockResponse blockResponse = (RPCBlockResponse)response;
                    LOG.info("Data " + blockId + " from remote machine " + address + " received");
                    RPCResponse.Status status = blockResponse.getStatus();
                    if (status == RPCResponse.Status.SUCCESS) {
                        return blockResponse.getPayloadDataBuffer().getReadOnlyByteBuffer();
                    }
                    throw new IOException(status.getMessage() + " response: " + blockResponse);
                }
                case RPC_ERROR_RESPONSE: {
                    RPCErrorResponse error = (RPCErrorResponse)response;
                    throw new IOException(error.getStatus().getMessage());
                }
            }
            throw new IOException("Unexpected response message type: " + response.getType() + " (expected: " + RPCMessage.Type.RPC_BLOCK_RESPONSE + ")");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

