/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.BlockOutStream;
import tachyon.client.OutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;
import tachyon.util.CommonUtils;

public class FileOutStream
extends OutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final long mBlockCapacityByte;
    private BlockOutStream mCurrentBlockOutStream;
    private List<BlockOutStream> mPreviousBlockOutStreams;
    private long mCachedBytes;
    private OutputStream mCheckpointOutputStream = null;
    private String mUnderFsFile = null;
    private boolean mClosed = false;
    private boolean mCancel = false;

    FileOutStream(TachyonFile file, WriteType opType, Object ufsConf, TachyonConf tachyonConf) throws IOException {
        super(file, opType, tachyonConf);
        this.mBlockCapacityByte = file.getBlockSizeByte();
        this.mCurrentBlockOutStream = null;
        this.mPreviousBlockOutStreams = new ArrayList<BlockOutStream>();
        this.mCachedBytes = 0L;
        if (this.mWriteType.isThrough()) {
            this.mUnderFsFile = CommonUtils.concatPath(this.mTachyonFS.createAndGetUserUfsTempFolder(ufsConf), this.mFile.mFileId);
            UnderFileSystem underfsClient = UnderFileSystem.get(this.mUnderFsFile, ufsConf, tachyonConf);
            if (this.mBlockCapacityByte > Integer.MAX_VALUE) {
                throw new IOException("BLOCK_CAPACITY (" + this.mBlockCapacityByte + ") can not bigger than " + Integer.MAX_VALUE);
            }
            this.mCheckpointOutputStream = underfsClient.create(this.mUnderFsFile, (int)this.mBlockCapacityByte);
        }
    }

    @Override
    public void cancel() throws IOException {
        this.mCancel = true;
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mCurrentBlockOutStream != null) {
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        Boolean canComplete = false;
        if (this.mWriteType.isThrough()) {
            if (this.mCancel) {
                this.mCheckpointOutputStream.close();
                UnderFileSystem underFsClient = UnderFileSystem.get(this.mUnderFsFile, this.mTachyonConf);
                underFsClient.delete(this.mUnderFsFile, false);
            } else {
                this.mCheckpointOutputStream.flush();
                this.mCheckpointOutputStream.close();
                this.mTachyonFS.addCheckpoint(this.mFile.mFileId);
                canComplete = true;
            }
        }
        if (this.mWriteType.isCache()) {
            try {
                if (this.mCancel) {
                    for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.cancel();
                    }
                } else {
                    for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.close();
                    }
                    canComplete = true;
                }
            }
            catch (IOException ioe) {
                if (this.mWriteType.isMustCache()) {
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType) + ", message: " + ioe.getMessage(), ioe);
                }
                LOG.warn("Fail to cache for: ", (Throwable)ioe);
            }
        }
        if (canComplete.booleanValue()) {
            if (this.mWriteType.isAsync()) {
                this.mTachyonFS.asyncCheckpoint(this.mFile.mFileId);
            }
            this.mTachyonFS.completeFile(this.mFile.mFileId);
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.flush();
        }
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockOutStream != null) {
            if (this.mCurrentBlockOutStream.getRemainingSpaceBytes() > 0L) {
                throw new IOException("The current block still has space left, no need to get new block");
            }
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.mWriteType.isCache()) {
            int offset = (int)(this.mCachedBytes / this.mBlockCapacityByte);
            this.mCurrentBlockOutStream = BlockOutStream.get(this.mFile, this.mWriteType, offset, this.mTachyonConf);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mWriteType.isCache()) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    long currentBlockLeftBytes;
                    if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.getRemainingSpaceBytes() == 0L) {
                        this.getNextBlock();
                    }
                    if ((currentBlockLeftBytes = this.mCurrentBlockOutStream.getRemainingSpaceBytes()) >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        this.mCachedBytes += (long)tLen;
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)currentBlockLeftBytes);
                    tOff = (int)((long)tOff + currentBlockLeftBytes);
                    tLen = (int)((long)tLen - currentBlockLeftBytes);
                    this.mCachedBytes += currentBlockLeftBytes;
                }
            }
            catch (IOException e) {
                if (this.mWriteType.isMustCache()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType) + ", message: " + e.getMessage(), e);
                }
                LOG.warn("Fail to cache for: ", (Throwable)e);
            }
        }
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.write(b, off, len);
            this.mTachyonFS.getClientMetrics().incBytesWrittenUfs(len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mWriteType.isCache()) {
            try {
                if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.getRemainingSpaceBytes() == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
                ++this.mCachedBytes;
            }
            catch (IOException e) {
                if (this.mWriteType.isMustCache()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType) + ", message: " + e.getMessage(), e);
                }
                LOG.warn("Fail to cache for: ", (Throwable)e);
            }
        }
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.write(b);
            this.mTachyonFS.getClientMetrics().incBytesWrittenUfs(1L);
        }
    }
}

