/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.LocalBlockOutStream;
import tachyon.client.OutStream;
import tachyon.client.RemoteBlockOutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;

public abstract class BlockOutStream
extends OutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    public static BlockOutStream get(TachyonFile tachyonFile, WriteType opType, int blockIndex, TachyonConf tachyonConf) throws IOException {
        return BlockOutStream.get(tachyonFile, opType, blockIndex, tachyonConf.getBytes("tachyon.user.quota.unit.bytes", 0x800000L), tachyonConf);
    }

    public static BlockOutStream get(TachyonFile tachyonFile, WriteType opType, int blockIndex, long initialBytes, TachyonConf tachyonConf) throws IOException {
        if (tachyonFile.mTachyonFS.hasLocalWorker() && tachyonConf.getBoolean("tachyon.user.localwrite.enable", true)) {
            LOG.info("Writing with local stream. tachyonFile: " + tachyonFile + ", blockIndex: " + blockIndex + ", opType: " + (Object)((Object)opType));
            return new LocalBlockOutStream(tachyonFile, opType, blockIndex, initialBytes, tachyonConf);
        }
        LOG.info("Writing with remote stream. tachyonFile: " + tachyonFile + ", blockIndex: " + blockIndex + ", opType: " + (Object)((Object)opType));
        return new RemoteBlockOutStream(tachyonFile, opType, blockIndex, initialBytes, tachyonConf);
    }

    protected BlockOutStream(TachyonFile tachyonFile, WriteType opType, TachyonConf tachyonConf) {
        super(tachyonFile, opType, tachyonConf);
    }

    public abstract long getRemainingSpaceBytes();
}

