/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.InStream;
import tachyon.client.LocalBlockInStream;
import tachyon.client.ReadType;
import tachyon.client.RemoteBlockInStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFile;
import tachyon.conf.TachyonConf;

public abstract class BlockInStream
extends InStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    protected final int mBlockIndex;
    protected boolean mClosed = false;

    public static BlockInStream get(TachyonFile tachyonFile, ReadType readType, int blockIndex, TachyonConf tachyonConf) throws IOException {
        return BlockInStream.get(tachyonFile, readType, blockIndex, tachyonFile.getUFSConf(), tachyonConf);
    }

    public static BlockInStream get(TachyonFile tachyonFile, ReadType readType, int blockIndex, Object ufsConf, TachyonConf tachyonConf) throws IOException {
        if (tachyonConf.getBoolean("tachyon.user.localread.enable", true)) {
            LOG.info("Reading with local stream.");
            TachyonByteBuffer buf = tachyonFile.readLocalByteBuffer(blockIndex);
            if (buf != null) {
                return new LocalBlockInStream(tachyonFile, readType, blockIndex, buf, tachyonConf);
            }
        }
        LOG.info("Reading with remote stream.");
        return new RemoteBlockInStream(tachyonFile, readType, blockIndex, ufsConf, tachyonConf);
    }

    BlockInStream(TachyonFile file, ReadType readType, int blockIndex, TachyonConf tachyonConf) throws IOException {
        super(file, readType, tachyonConf);
        this.mBlockIndex = blockIndex;
    }
}

