/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.HeartbeatThread;
import tachyon.conf.UserConf;
import tachyon.master.MasterClient;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TFramedTransport;
import tachyon.org.apache.thrift.transport.TSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FailedToCheckpointException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.NoWorkerException;
import tachyon.thrift.OutOfSpaceException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TachyonException;
import tachyon.thrift.WorkerService;
import tachyon.util.NetworkUtils;
import tachyon.worker.WorkerClientHeartbeatExecutor;

public class WorkerClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final MasterClient mMasterClient;
    private static final int CONNECTION_RETRY_TIMES = 5;
    private WorkerService.Client mClient;
    private TProtocol mProtocol;
    private InetSocketAddress mWorkerAddress;
    private boolean mConnected = false;
    private boolean mIsLocal = false;
    private final ExecutorService mExecutorService;
    private Future<?> mHeartbeat;

    public WorkerClient(MasterClient masterClient, ExecutorService executorService) throws IOException {
        this.mMasterClient = masterClient;
        this.mExecutorService = executorService;
    }

    public synchronized void accessBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.accessBlock(blockId);
        }
        catch (TException e) {
            LOG.error("TachyonClient accessLocalBlock(" + blockId + ") failed");
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void addCheckpoint(int fileId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.addCheckpoint(this.mMasterClient.getUserId(), fileId);
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (SuspectedFileSizeException e) {
            throw new IOException(e);
        }
        catch (FailedToCheckpointException e) {
            throw new IOException(e);
        }
        catch (BlockInfoException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean asyncCheckpoint(int fid) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.asyncCheckpoint(fid);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void cacheBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.cacheBlock(this.mMasterClient.getUserId(), blockId);
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (BlockInfoException e) {
            throw new IOException(e);
        }
        catch (SuspectedFileSizeException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void cancelBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.cancelBlock(this.mMasterClient.getUserId(), blockId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.mConnected) {
            try {
                this.mProtocol.getTransport().close();
            }
            finally {
                if (this.mHeartbeat != null) {
                    this.mHeartbeat.cancel(true);
                }
            }
            this.mConnected = false;
        }
    }

    private synchronized boolean connect() throws IOException {
        if (!this.mConnected) {
            NetAddress workerNetAddress = null;
            try {
                String localHostName = NetworkUtils.getLocalHostName();
                LOG.info("Trying to get local worker host : " + localHostName);
                workerNetAddress = this.mMasterClient.user_getWorker(false, localHostName);
                this.mIsLocal = true;
            }
            catch (NoWorkerException e) {
                LOG.info(e.getMessage());
                workerNetAddress = null;
            }
            catch (UnknownHostException e) {
                LOG.info(e.getMessage());
                workerNetAddress = null;
            }
            if (workerNetAddress == null) {
                try {
                    workerNetAddress = this.mMasterClient.user_getWorker(true, "");
                }
                catch (NoWorkerException e) {
                    LOG.info("No worker running in the system: " + e.getMessage());
                    this.mClient = null;
                    return false;
                }
            }
            String host = NetworkUtils.getFqdnHost(workerNetAddress);
            int port = workerNetAddress.mPort;
            this.mWorkerAddress = new InetSocketAddress(host, port);
            LOG.info("Connecting " + (this.mIsLocal ? "local" : "remote") + " worker @ " + this.mWorkerAddress);
            this.mProtocol = new TBinaryProtocol(new TFramedTransport(new TSocket(host, port)));
            this.mClient = new WorkerService.Client(this.mProtocol);
            WorkerClientHeartbeatExecutor heartBeater = new WorkerClientHeartbeatExecutor(this, this.mMasterClient.getUserId());
            String threadName = "worker-heartbeat-" + this.mWorkerAddress;
            this.mHeartbeat = this.mExecutorService.submit(new HeartbeatThread(threadName, heartBeater, UserConf.get().HEARTBEAT_INTERVAL_MS));
            try {
                this.mProtocol.getTransport().open();
            }
            catch (TTransportException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            this.mConnected = true;
        }
        return this.mConnected;
    }

    public synchronized InetSocketAddress getAddress() {
        return this.mWorkerAddress;
    }

    public synchronized String getUserUfsTempFolder() throws IOException {
        this.mustConnect();
        try {
            return this.mClient.getUserUfsTempFolder(this.mMasterClient.getUserId());
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean isConnected() {
        return this.mConnected;
    }

    public synchronized boolean isLocal() {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.mIsLocal;
    }

    public synchronized String lockBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.lockBlock(blockId, this.mMasterClient.getUserId());
        }
        catch (FileDoesNotExistException e) {
            return null;
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void mustConnect() throws IOException {
        int tries = 0;
        while (tries++ <= 5) {
            if (!this.connect()) continue;
            return;
        }
        throw new IOException("Failed to connect to the worker");
    }

    public synchronized boolean promoteBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.promoteBlock(blockId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized String requestBlockLocation(long blockId, long initialBytes) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.requestBlockLocation(this.mMasterClient.getUserId(), blockId, initialBytes);
        }
        catch (OutOfSpaceException e) {
            throw new IOException(e);
        }
        catch (FileAlreadyExistException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean requestSpace(long blockId, long requestBytes) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.requestSpace(this.mMasterClient.getUserId(), blockId, requestBytes);
        }
        catch (OutOfSpaceException e) {
            return false;
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean unlockBlock(long blockId) throws IOException {
        this.mustConnect();
        try {
            return this.mClient.unlockBlock(blockId, this.mMasterClient.getUserId());
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void userHeartbeat(long userId) throws IOException {
        this.mustConnect();
        try {
            this.mClient.userHeartbeat(userId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }
}

